/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.catalog.domain.SkuBundleItem;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;

@XmlRootElement(name="skuBundleItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SkuBundleItemWrapper
extends BaseWrapper
implements APIWrapper<SkuBundleItem> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Integer quantity;
    @XmlElement
    protected Money salePrice;
    @XmlElement
    protected Money retailPrice;
    @XmlElement
    protected Long bundleId;
    @XmlElement
    protected SkuWrapper sku;
    @XmlElement
    protected String name;
    @XmlElement
    protected Boolean active;
    @XmlElement
    protected String description;
    @XmlElement
    protected String longDescription;

    @Override
    public void wrapDetails(SkuBundleItem model, HttpServletRequest request) {
        this.id = model.getId();
        this.quantity = model.getQuantity();
        this.salePrice = model.getSalePrice();
        this.retailPrice = model.getRetailPrice();
        this.bundleId = model.getBundle().getId();
        this.name = model.getSku().getName();
        this.description = model.getSku().getDescription();
        this.longDescription = model.getSku().getLongDescription();
        this.active = model.getSku().isActive();
    }

    @Override
    public void wrapSummary(SkuBundleItem model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }
}

