/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.offer.domain.Adjustment;
import org.broadleafcommerce.core.offer.domain.OrderAdjustment;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderAttribute;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AdjustmentWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CustomerWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentInfoWrapper;

@XmlRootElement(name="order")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderWrapper
extends BaseWrapper
implements APIWrapper<Order> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String status;
    @XmlElement
    protected Money totalTax;
    @XmlElement
    protected Money totalShipping;
    @XmlElement
    protected Money subTotal;
    @XmlElement
    protected Money total;
    @XmlElement
    protected CustomerWrapper customer;
    @XmlElement(name="orderItem")
    @XmlElementWrapper(name="orderItems")
    protected List<OrderItemWrapper> orderItems;
    @XmlElement(name="fulfillmentGroup")
    @XmlElementWrapper(name="fulfillmentGroups")
    protected List<FulfillmentGroupWrapper> fulfillmentGroups;
    @XmlElement(name="paymentInfo")
    @XmlElementWrapper(name="paymentInfos")
    protected List<PaymentInfoWrapper> paymentInfos;
    @XmlElement(name="orderAdjustment")
    @XmlElementWrapper(name="orderAdjustments")
    protected List<AdjustmentWrapper> orderAdjustments;
    @XmlElement(name="orderAttribute")
    @XmlElementWrapper(name="orderAttributes")
    protected List<OrderAttributeWrapper> orderAttributes;

    @Override
    public void wrapDetails(Order model, HttpServletRequest request) {
        this.id = model.getId();
        this.status = model.getStatus().getType();
        this.totalTax = model.getTotalTax();
        this.totalShipping = model.getTotalShipping();
        this.subTotal = model.getSubTotal();
        this.total = model.getTotal();
        if (model.getOrderItems() != null && !model.getOrderItems().isEmpty()) {
            this.orderItems = new ArrayList<OrderItemWrapper>();
            for (OrderItem orderItem : model.getOrderItems()) {
                OrderItemWrapper orderItemWrapper = (OrderItemWrapper)this.context.getBean(OrderItemWrapper.class.getName());
                orderItemWrapper.wrapSummary(orderItem, request);
                this.orderItems.add(orderItemWrapper);
            }
        }
        if (model.getFulfillmentGroups() != null && !model.getFulfillmentGroups().isEmpty()) {
            this.fulfillmentGroups = new ArrayList<FulfillmentGroupWrapper>();
            for (FulfillmentGroup fulfillmentGroup : model.getFulfillmentGroups()) {
                FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                fulfillmentGroupWrapper.wrapSummary(fulfillmentGroup, request);
                this.fulfillmentGroups.add(fulfillmentGroupWrapper);
            }
        }
        if (model.getPaymentInfos() != null && !model.getPaymentInfos().isEmpty()) {
            this.paymentInfos = new ArrayList<PaymentInfoWrapper>();
            for (PaymentInfo paymentInfo : model.getPaymentInfos()) {
                PaymentInfoWrapper paymentInfoWrapper = (PaymentInfoWrapper)this.context.getBean(PaymentInfoWrapper.class.getName());
                paymentInfoWrapper.wrapSummary(paymentInfo, request);
                this.paymentInfos.add(paymentInfoWrapper);
            }
        }
        if (model.getOrderAdjustments() != null && !model.getOrderAdjustments().isEmpty()) {
            this.orderAdjustments = new ArrayList<AdjustmentWrapper>();
            for (OrderAdjustment orderAdjustment : model.getOrderAdjustments()) {
                AdjustmentWrapper orderAdjustmentWrapper = (AdjustmentWrapper)this.context.getBean(AdjustmentWrapper.class.getName());
                orderAdjustmentWrapper.wrapSummary((Adjustment)orderAdjustment, request);
                this.orderAdjustments.add(orderAdjustmentWrapper);
            }
        }
        if (model.getOrderAttributes() != null && !model.getOrderAttributes().isEmpty()) {
            Map itemAttributes = model.getOrderAttributes();
            this.orderAttributes = new ArrayList<OrderAttributeWrapper>();
            Set keys = itemAttributes.keySet();
            for (String key : keys) {
                OrderAttributeWrapper orderAttributeWrapper = (OrderAttributeWrapper)this.context.getBean(OrderAttributeWrapper.class.getName());
                orderAttributeWrapper.wrapSummary((OrderAttribute)itemAttributes.get(key), request);
                this.orderAttributes.add(orderAttributeWrapper);
            }
        }
        CustomerWrapper customerWrapper = (CustomerWrapper)this.context.getBean(CustomerWrapper.class.getName());
        customerWrapper.wrapDetails(model.getCustomer(), request);
        this.customer = customerWrapper;
    }

    @Override
    public void wrapSummary(Order model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }
}

