/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account.validator;

import org.broadleafcommerce.common.security.util.PasswordChange;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component(value="blChangePasswordValidator")
public class ChangePasswordValidator
implements Validator {
    public static final String DEFAULT_VALID_PASSWORD_REGEX = "[0-9A-Za-z]{4,15}";
    private String validPasswordRegex = "[0-9A-Za-z]{4,15}";

    public void validate(PasswordChange passwordChange, Errors errors) {
        String currentPassword = passwordChange.getCurrentPassword();
        String password = passwordChange.getNewPassword();
        String passwordConfirm = passwordChange.getNewPasswordConfirm();
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"currentPassword", (String)"currentPassword.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"newPassword", (String)"newPassword.required");
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"newPasswordConfirm", (String)"newPasswordConfirm.required");
        if (!errors.hasErrors()) {
            if (!currentPassword.equals(CustomerState.getCustomer().getPassword())) {
                errors.rejectValue("currentPassword", "currentPassword.invalid");
            }
            if (!passwordConfirm.equals(password)) {
                errors.rejectValue("newPasswordConfirm", "newPasswordConfirm.invalid");
            }
            if (!password.matches(this.validPasswordRegex)) {
                errors.rejectValue("newPassword", "newPassword.invalid");
            }
        }
    }

    public String getValidPasswordRegex() {
        return this.validPasswordRegex;
    }

    public void setValidPasswordRegex(String validPasswordRegex) {
        this.validPasswordRegex = validPasswordRegex;
    }

    public boolean supports(Class<?> clazz) {
        return false;
    }

    public void validate(Object target, Errors errors) {
    }
}

