/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.media.domain.Media;
import org.broadleafcommerce.common.security.service.ExploitProtectionService;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryAttribute;
import org.broadleafcommerce.core.catalog.domain.CategoryProductXref;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.ProductSearchResult;
import org.broadleafcommerce.core.search.service.SearchService;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.CategoriesWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CategoryAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CategoryWrapper;
import org.broadleafcommerce.core.web.api.wrapper.MediaWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.RelatedProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SearchResultsWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;
import org.broadleafcommerce.core.web.service.SearchFacetDTOService;

public abstract class CatalogEndpoint
extends BaseEndpoint {
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;
    @Resource(name="blSearchService")
    protected SearchService searchService;
    @Resource(name="blSearchFacetDTOService")
    protected SearchFacetDTOService facetService;
    @Resource(name="blExploitProtectionService")
    protected ExploitProtectionService exploitProtectionService;
    protected StaticAssetService staticAssetService;

    public ProductWrapper findProductById(HttpServletRequest request, Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ProductWrapper wrapper = (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
            wrapper.wrapDetails(product, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public SearchResultsWrapper findProductsByCategoryAndQuery(HttpServletRequest request, Long categoryId, String q, Integer pageSize, Integer page) {
        try {
            if (!StringUtils.isNotEmpty((String)q)) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Search query was empty. Set parameter 'q' to query for a product. (e.g. q=My Product Name).").build());
            }
            q = StringUtils.trim((String)q);
            q = this.exploitProtectionService.cleanString(q);
        }
        catch (ServiceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("The search query: " + q + " was incorrect or malformed.")).build());
        }
        if (categoryId == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"The categoryId was null.").build());
        }
        Category category = null;
        category = this.catalogService.findCategoryById(categoryId);
        if (category == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("Category ID, " + categoryId + ", was not associated with a category.")).build());
        }
        List availableFacets = this.searchService.getSearchFacets();
        ProductSearchCriteria searchCriteria = this.facetService.buildSearchCriteria(request, availableFacets);
        try {
            ProductSearchResult result = null;
            result = this.searchService.findProductsByCategoryAndQuery(category, q, searchCriteria);
            this.facetService.setActiveFacetResults(result.getFacets(), request);
            SearchResultsWrapper wrapper = (SearchResultsWrapper)this.context.getBean(SearchResultsWrapper.class.getName());
            wrapper.wrapDetails(result, request);
            return wrapper;
        }
        catch (ServiceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"Problem occured executing search.").build());
        }
    }

    public SearchResultsWrapper findProductsByQuery(HttpServletRequest request, String q, Integer pageSize, Integer page) {
        try {
            if (!StringUtils.isNotEmpty((String)q)) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)"Search query was empty. Set parameter 'q' to query for a product. (e.g. q=My Product Name).").build());
            }
            q = StringUtils.trim((String)q);
            q = this.exploitProtectionService.cleanString(q);
        }
        catch (ServiceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("The search query: " + q + " was incorrect or malformed.")).build());
        }
        List availableFacets = this.searchService.getSearchFacets();
        ProductSearchCriteria searchCriteria = this.facetService.buildSearchCriteria(request, availableFacets);
        try {
            ProductSearchResult result = null;
            result = this.searchService.findProductsByQuery(q, searchCriteria);
            this.facetService.setActiveFacetResults(result.getFacets(), request);
            SearchResultsWrapper wrapper = (SearchResultsWrapper)this.context.getBean(SearchResultsWrapper.class.getName());
            wrapper.wrapDetails(result, request);
            return wrapper;
        }
        catch (ServiceException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"Problem occured executing search.").build());
        }
    }

    public List<SkuWrapper> findSkusByProductById(HttpServletRequest request, Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            List skus = product.getAllSkus();
            ArrayList<SkuWrapper> out = new ArrayList<SkuWrapper>();
            if (skus != null) {
                for (Sku sku : skus) {
                    SkuWrapper wrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
                    wrapper.wrapSummary(sku, request);
                    out.add(wrapper);
                }
                return out;
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public SkuWrapper findDefaultSkuByProductId(HttpServletRequest request, Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null && product.getDefaultSku() != null) {
            SkuWrapper wrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
            wrapper.wrapDetails(product.getDefaultSku(), request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public CategoriesWrapper findAllCategories(HttpServletRequest request, String name, int limit, int offset) {
        List categories = name != null ? this.catalogService.findCategoriesByName(name, limit, offset) : this.catalogService.findAllCategories(limit, offset);
        CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
        wrapper.wrapDetails(categories, request);
        return wrapper;
    }

    public CategoriesWrapper findSubCategories(HttpServletRequest request, Long id, int limit, int offset, boolean active) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
            List categories = active ? this.catalogService.findActiveSubCategoriesByCategory(category, limit, offset) : this.catalogService.findAllSubCategories(category, limit, offset);
            wrapper.wrapDetails(categories, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Category with Id " + id + " could not be found")).build());
    }

    public CategoriesWrapper findActiveSubCategories(HttpServletRequest request, Long id, int limit, int offset) {
        return this.findSubCategories(request, id, limit, offset, true);
    }

    public CategoryWrapper findCategoryById(HttpServletRequest request, Long id, int productLimit, int productOffset, int subcategoryLimit, int subcategoryOffset) {
        Category cat = this.catalogService.findCategoryById(id);
        if (cat != null) {
            request.setAttribute("productLimit", (Object)productLimit);
            request.setAttribute("productOffset", (Object)productOffset);
            request.setAttribute("subcategoryLimit", (Object)subcategoryLimit);
            request.setAttribute("subcategoryOffset", (Object)subcategoryOffset);
            CategoryWrapper wrapper = (CategoryWrapper)this.context.getBean(CategoryWrapper.class.getName());
            wrapper.wrapDetails(cat, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Category with Id " + id + " could not be found")).build());
    }

    public CategoryWrapper findCategoryByIdOrName(HttpServletRequest request, String searchParameter, int productLimit, int productOffset, int subcategoryLimit, int subcategoryOffset) {
        Category cat;
        block4: {
            cat = null;
            if (searchParameter != null) {
                try {
                    cat = this.catalogService.findCategoryById(Long.valueOf(Long.parseLong(searchParameter)));
                }
                catch (NumberFormatException e) {
                    List categories = this.catalogService.findCategoriesByName(searchParameter);
                    if (categories == null || categories.isEmpty()) break block4;
                    cat = (Category)categories.get(0);
                }
            }
        }
        if (cat != null) {
            request.setAttribute("productLimit", (Object)productLimit);
            request.setAttribute("productOffset", (Object)productOffset);
            request.setAttribute("subcategoryLimit", (Object)subcategoryLimit);
            request.setAttribute("subcategoryOffset", (Object)subcategoryOffset);
            CategoryWrapper wrapper = (CategoryWrapper)this.context.getBean(CategoryWrapper.class.getName());
            wrapper.wrapDetails(cat, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Category with Id or name of " + searchParameter + " could not be found")).build());
    }

    public List<CategoryAttributeWrapper> findCategoryAttributesForCategory(HttpServletRequest request, Long id) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            ArrayList<CategoryAttributeWrapper> out = new ArrayList<CategoryAttributeWrapper>();
            if (category.getCategoryAttributes() != null) {
                for (CategoryAttribute attribute : category.getCategoryAttributes()) {
                    CategoryAttributeWrapper wrapper = (CategoryAttributeWrapper)this.context.getBean(CategoryAttributeWrapper.class.getName());
                    wrapper.wrapSummary(attribute, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Category with Id " + id + " could not be found")).build());
    }

    public List<RelatedProductWrapper> findUpSaleProductsByProduct(HttpServletRequest request, Long id, int limit, int offset) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<RelatedProductWrapper> out = new ArrayList<RelatedProductWrapper>();
            List relatedProds = product.getUpSaleProducts();
            if (relatedProds != null) {
                for (RelatedProduct prod : relatedProds) {
                    RelatedProductWrapper wrapper = (RelatedProductWrapper)this.context.getBean(RelatedProductWrapper.class.getName());
                    wrapper.wrapSummary(prod, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public List<RelatedProductWrapper> findCrossSaleProductsByProduct(HttpServletRequest request, Long id, int limit, int offset) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<RelatedProductWrapper> out = new ArrayList<RelatedProductWrapper>();
            List xSellProds = product.getCrossSaleProducts();
            if (xSellProds != null) {
                for (RelatedProduct prod : xSellProds) {
                    RelatedProductWrapper wrapper = (RelatedProductWrapper)this.context.getBean(RelatedProductWrapper.class.getName());
                    wrapper.wrapSummary(prod, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public List<ProductAttributeWrapper> findProductAttributesForProduct(HttpServletRequest request, Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<ProductAttributeWrapper> out = new ArrayList<ProductAttributeWrapper>();
            if (product.getProductAttributes() != null) {
                for (Map.Entry entry : product.getProductAttributes().entrySet()) {
                    ProductAttributeWrapper wrapper = (ProductAttributeWrapper)this.context.getBean(ProductAttributeWrapper.class.getName());
                    wrapper.wrapSummary((ProductAttribute)entry.getValue(), request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public List<SkuAttributeWrapper> findSkuAttributesForSku(HttpServletRequest request, Long id) {
        Sku sku = this.catalogService.findSkuById(id);
        if (sku != null) {
            ArrayList<SkuAttributeWrapper> out = new ArrayList<SkuAttributeWrapper>();
            if (sku.getSkuAttributes() != null) {
                for (Map.Entry entry : sku.getSkuAttributes().entrySet()) {
                    SkuAttributeWrapper wrapper = (SkuAttributeWrapper)this.context.getBean(SkuAttributeWrapper.class.getName());
                    wrapper.wrapSummary((SkuAttribute)entry.getValue(), request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Sku with Id " + id + " could not be found")).build());
    }

    public List<MediaWrapper> findMediaForSku(HttpServletRequest request, Long id) {
        Sku sku = this.catalogService.findSkuById(id);
        if (sku != null) {
            ArrayList<MediaWrapper> medias = new ArrayList<MediaWrapper>();
            if (sku.getSkuMedia() != null && !sku.getSkuMedia().isEmpty()) {
                for (Media media : sku.getSkuMedia().values()) {
                    MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                    wrapper.wrapSummary(media, request);
                    if (wrapper.isAllowOverrideUrl()) {
                        wrapper.setUrl(this.getStaticAssetService().convertAssetPath(media.getUrl(), request.getContextPath(), request.isSecure()));
                    }
                    medias.add(wrapper);
                }
            }
            return medias;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Sku with Id " + id + " could not be found")).build());
    }

    public SkuWrapper findSkuById(HttpServletRequest request, Long id) {
        Sku sku = this.catalogService.findSkuById(id);
        if (sku != null) {
            SkuWrapper wrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
            wrapper.wrapDetails(sku, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Sku with Id " + id + " could not be found")).build());
    }

    public List<MediaWrapper> findMediaForProduct(HttpServletRequest request, Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<MediaWrapper> out = new ArrayList<MediaWrapper>();
            Map media = product.getMedia();
            if (media != null) {
                for (Media med : media.values()) {
                    MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                    wrapper.wrapSummary(med, request);
                    if (wrapper.isAllowOverrideUrl()) {
                        wrapper.setUrl(this.getStaticAssetService().convertAssetPath(med.getUrl(), request.getContextPath(), request.isSecure()));
                    }
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    public List<MediaWrapper> findMediaForCategory(HttpServletRequest request, Long id) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            ArrayList<MediaWrapper> out = new ArrayList<MediaWrapper>();
            Map media = category.getCategoryMedia();
            for (Media med : media.values()) {
                MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                wrapper.wrapSummary(med, request);
                out.add(wrapper);
            }
            return out;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Category with Id " + id + " could not be found")).build());
    }

    public CategoriesWrapper findParentCategoriesForProduct(HttpServletRequest request, Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
            ArrayList<Category> categories = new ArrayList<Category>();
            for (CategoryProductXref categoryXref : product.getAllParentCategoryXrefs()) {
                categories.add(categoryXref.getCategory());
            }
            wrapper.wrapDetails((List<Category>)categories, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Product with Id " + id + " could not be found")).build());
    }

    protected StaticAssetService getStaticAssetService() {
        if (this.staticAssetService == null) {
            this.staticAssetService = (StaticAssetService)this.context.getBean("blStaticAssetService");
        }
        return this.staticAssetService;
    }

    public static void main(String[] args) {
        System.out.println(StringUtils.isNotEmpty(null));
    }
}

