/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.annotation.Scope;

@Scope(value="singleton")
@Provider
public class BroadleafRestExceptionMapper
implements ExceptionMapper<Throwable>,
MessageSourceAware {
    private static final Log LOG = LogFactory.getLog(BroadleafRestExceptionMapper.class);
    protected MessageSource messageSource;

    public Response toResponse(Throwable t) {
        Response response = null;
        if (t instanceof WebApplicationException) {
            response = ((WebApplicationException)t).getResponse();
            if (response.getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                LOG.error((Object)("An exception was caught by the JAX-RS framework: Status: " + response.getStatus() + " Message: " + response.getEntity()), t);
            } else if (response.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                LOG.warn((Object)("Someone tried to access a resource that was forbidden: Status: " + response.getStatus() + " Message: " + response.getEntity()), t);
            } else if (response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Bad Request: Status: " + response.getStatus() + " Message: " + response.getEntity()), t);
            } else if (response.getStatus() == Response.Status.NOT_ACCEPTABLE.getStatusCode() && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Not acceptable: Status: " + response.getStatus() + " Message: " + response.getEntity()), t);
            } else {
                LOG.error((Object)("An exception was caught by the JAX-RS framework: Status: " + response.getStatus() + " Message: " + response.getEntity()), t);
            }
        } else {
            LOG.error((Object)"An exception was caught by the JAX-RS framework: ", t);
        }
        if (response != null) {
            Object msg = response.getEntity();
            if (msg == null) {
                msg = "An error occurred";
            }
            return Response.status((int)response.getStatus()).type("text/plain").entity(msg).build();
        }
        return Response.status((int)500).type("text/plain").entity((Object)"An unknown or unreported error has occured. If the problem persists, please contact the administrator.").build();
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }
}

