/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.vendor.service.exception.FulfillmentPriceException;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentOption;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.payment.domain.CreditCardPaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.pricing.service.fulfillment.provider.FulfillmentEstimationResponse;
import org.broadleafcommerce.core.web.checkout.model.BillingInfoForm;
import org.broadleafcommerce.core.web.checkout.model.MultiShipInstructionForm;
import org.broadleafcommerce.core.web.checkout.model.OrderInfoForm;
import org.broadleafcommerce.core.web.checkout.model.OrderMultishipOptionForm;
import org.broadleafcommerce.core.web.checkout.model.ShippingInfoForm;
import org.broadleafcommerce.core.web.controller.checkout.AbstractCheckoutController;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.AddressImpl;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.Phone;
import org.broadleafcommerce.profile.core.domain.PhoneImpl;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.joda.time.DateTime;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafCheckoutController
extends AbstractCheckoutController {
    private static final Log LOG = LogFactory.getLog(BroadleafCheckoutController.class);
    protected static String cartPageRedirect = "redirect:/cart";
    protected static String checkoutView = "checkout/checkout";
    protected static String checkoutPageRedirect = "redirect:/checkout";
    protected static String multishipView = "checkout/multiship";
    protected static String multishipAddAddressView = "checkout/multishipAddAddressForm";
    protected static String multishipAddAddressSuccessView = "redirect:/checkout/multiship";
    protected static String multishipSuccessView = "redirect:/checkout";
    protected static String baseConfirmationView = "ajaxredirect:/confirmation";

    public String checkout(HttpServletRequest request, HttpServletResponse response, Model model, RedirectAttributes redirectAttributes) {
        Order cart = CartState.getCart();
        if (!(cart instanceof NullOrderImpl)) {
            model.addAttribute("orderMultishipOptions", (Object)this.orderMultishipOptionService.getOrGenerateOrderMultishipOptions(cart));
        }
        this.populateModelWithShippingReferenceData(request, model);
        return this.getCheckoutView();
    }

    public String convertToSingleship(HttpServletRequest request, HttpServletResponse response, Model model) throws PricingException {
        Order cart = CartState.getCart();
        this.fulfillmentGroupService.collapseToOneFulfillmentGroup(cart, true);
        return this.getCheckoutPageRedirect();
    }

    public String saveGlobalOrderDetails(HttpServletRequest request, Model model, OrderInfoForm orderInfoForm, BindingResult result) throws ServiceException {
        Order cart = CartState.getCart();
        this.orderInfoFormValidator.validate(orderInfoForm, (Errors)result);
        if (result.hasErrors()) {
            try {
                cart.setEmailAddress(null);
                this.orderService.save(cart, Boolean.valueOf(false));
            }
            catch (PricingException pe) {
                LOG.error((Object)"Error when saving the email address for order confirmation to the cart", (Throwable)pe);
            }
            this.populateModelWithShippingReferenceData(request, model);
            return this.getCheckoutView();
        }
        try {
            cart.setEmailAddress(orderInfoForm.getEmailAddress());
            this.orderService.save(cart, Boolean.valueOf(false));
        }
        catch (PricingException pe) {
            LOG.error((Object)"Error when saving the email address for order confirmation to the cart", (Throwable)pe);
        }
        return this.getCheckoutPageRedirect();
    }

    public String saveSingleShip(HttpServletRequest request, HttpServletResponse response, Model model, ShippingInfoForm shippingForm, BindingResult result) throws PricingException, ServiceException {
        Order cart = CartState.getCart();
        this.shippingInfoFormValidator.validate(shippingForm, (Errors)result);
        if (result.hasErrors()) {
            this.putFulfillmentOptionsAndEstimationOnModel(model);
            this.populateModelWithShippingReferenceData(request, model);
            model.addAttribute("states", (Object)this.stateService.findStates());
            model.addAttribute("countries", (Object)this.countryService.findCountries());
            model.addAttribute("expirationMonths", this.populateExpirationMonths());
            model.addAttribute("expirationYears", this.populateExpirationYears());
            model.addAttribute("validShipping", (Object)false);
            return this.getCheckoutView();
        }
        FulfillmentGroup fulfillmentGroup = (FulfillmentGroup)cart.getFulfillmentGroups().get(0);
        if (StringUtils.isEmpty((String)shippingForm.getAddress().getPhonePrimary().getPhoneNumber())) {
            shippingForm.getAddress().setPhonePrimary(null);
        }
        fulfillmentGroup.setAddress(shippingForm.getAddress());
        fulfillmentGroup.setPersonalMessage(shippingForm.getPersonalMessage());
        fulfillmentGroup.setDeliveryInstruction(shippingForm.getDeliveryMessage());
        FulfillmentOption fulfillmentOption = this.fulfillmentOptionService.readFulfillmentOptionById(shippingForm.getFulfillmentOptionId());
        fulfillmentGroup.setFulfillmentOption(fulfillmentOption);
        cart = this.orderService.save(cart, Boolean.valueOf(true));
        CartState.setCart(cart);
        return this.isAjaxRequest(request) ? this.getCheckoutView() : this.getCheckoutPageRedirect();
    }

    public String savePaymentForm(HttpServletRequest request, HttpServletResponse response, Model model) throws PricingException {
        return this.isAjaxRequest(request) ? this.getCheckoutView() : this.getCheckoutPageRedirect();
    }

    public String showMultiship(HttpServletRequest request, HttpServletResponse response, Model model) {
        Customer customer = CustomerState.getCustomer();
        Order cart = CartState.getCart();
        model.addAttribute("orderMultishipOptions", (Object)this.orderMultishipOptionService.getOrGenerateOrderMultishipOptions(cart));
        model.addAttribute("customerAddresses", (Object)this.customerAddressService.readActiveCustomerAddressesByCustomerId(customer.getId()));
        model.addAttribute("fulfillmentOptions", (Object)this.fulfillmentOptionService.readAllFulfillmentOptions());
        return this.getMultishipView();
    }

    public String saveMultiship(HttpServletRequest request, HttpServletResponse response, Model model, OrderMultishipOptionForm orderMultishipOptionForm, BindingResult result) throws PricingException, ServiceException {
        Order cart = CartState.getCart();
        this.orderMultishipOptionService.saveOrderMultishipOptions(cart, orderMultishipOptionForm.getOptions());
        cart = this.fulfillmentGroupService.matchFulfillmentGroupsToMultishipOptions(cart, true);
        return this.getMultishipSuccessView();
    }

    public String showMultishipAddAddress(HttpServletRequest request, HttpServletResponse response, Model model) {
        model.addAttribute("states", (Object)this.stateService.findStates());
        model.addAttribute("countries", (Object)this.countryService.findCountries());
        return this.getMultishipAddAddressView();
    }

    public String saveMultishipAddAddress(HttpServletRequest request, HttpServletResponse response, Model model, ShippingInfoForm addressForm, BindingResult result) throws ServiceException {
        this.multishipAddAddressFormValidator.validate(addressForm, (Errors)result);
        if (result.hasErrors()) {
            return this.showMultishipAddAddress(request, response, model);
        }
        Address address = this.addressService.saveAddress(addressForm.getAddress());
        CustomerAddress customerAddress = this.customerAddressService.create();
        customerAddress.setAddressName(addressForm.getAddressName());
        customerAddress.setAddress(address);
        customerAddress.setCustomer(CustomerState.getCustomer());
        this.customerAddressService.saveCustomerAddress(customerAddress);
        return this.getMultishipAddAddressSuccessView() + "?_=" + System.currentTimeMillis();
    }

    public String saveMultiShipInstruction(HttpServletRequest request, HttpServletResponse response, Model model, MultiShipInstructionForm instructionForm) throws ServiceException, PricingException {
        Order cart = CartState.getCart();
        FulfillmentGroup fulfillmentGroup = null;
        for (FulfillmentGroup tempFulfillmentGroup : cart.getFulfillmentGroups()) {
            if (!tempFulfillmentGroup.getId().equals(instructionForm.getFulfillmentGroupId())) continue;
            fulfillmentGroup = tempFulfillmentGroup;
        }
        fulfillmentGroup.setPersonalMessage(instructionForm.getPersonalMessage());
        fulfillmentGroup.setDeliveryInstruction(instructionForm.getDeliveryMessage());
        this.fulfillmentGroupService.save(fulfillmentGroup);
        return this.getCheckoutPageRedirect() + "?_=" + System.currentTimeMillis();
    }

    public String completeCheckout(HttpServletRequest request, HttpServletResponse response, Model model, BillingInfoForm billingForm, BindingResult result) throws CheckoutException, PricingException, ServiceException {
        if (billingForm.getPaymentMethod() == null || "credit_card".equals(billingForm.getPaymentMethod())) {
            return this.completeSecureCreditCardCheckout(request, response, model, billingForm, result);
        }
        throw new IllegalArgumentException("Complete checkout called with payment Method " + billingForm.getPaymentMethod() + " which has not been implemented.");
    }

    public String completeSecureCreditCardCheckout(HttpServletRequest request, HttpServletResponse response, Model model, BillingInfoForm billingForm, BindingResult result) throws CheckoutException, PricingException, ServiceException {
        Order cart = CartState.getCart();
        if (cart != null) {
            HashMap<PaymentInfo, CreditCardPaymentInfo> payments = new HashMap<PaymentInfo, CreditCardPaymentInfo>();
            this.orderService.removePaymentsFromOrder(cart, PaymentInfoType.CREDIT_CARD);
            if (billingForm.isUseShippingAddress()) {
                this.copyShippingAddressToBillingAddress(cart, billingForm);
            }
            this.billingInfoFormValidator.validate(billingForm, (Errors)result);
            if (result.hasErrors()) {
                this.populateModelWithShippingReferenceData(request, model);
                return this.getCheckoutView();
            }
            PaymentInfo ccInfo = this.creditCardPaymentInfoFactory.constructPaymentInfo(cart);
            ccInfo.setAddress(billingForm.getAddress());
            cart.getPaymentInfos().add(ccInfo);
            CreditCardPaymentInfo ccReference = (CreditCardPaymentInfo)this.securePaymentInfoService.create(PaymentInfoType.CREDIT_CARD);
            ccReference.setNameOnCard(billingForm.getCreditCardName());
            ccReference.setReferenceNumber(ccInfo.getReferenceNumber());
            ccReference.setPan(billingForm.getCreditCardNumber());
            ccReference.setCvvCode(billingForm.getCreditCardCvvCode());
            ccReference.setExpirationMonth(Integer.valueOf(Integer.parseInt(billingForm.getCreditCardExpMonth())));
            ccReference.setExpirationYear(Integer.valueOf(Integer.parseInt(billingForm.getCreditCardExpYear())));
            payments.put(ccInfo, ccReference);
            CheckoutResponse checkoutResponse = this.checkoutService.performCheckout(cart, payments);
            if (!((PaymentResponseItem)checkoutResponse.getPaymentResponse().getResponseItems().get(ccInfo)).getTransactionSuccess().booleanValue()) {
                this.populateModelWithShippingReferenceData(request, model);
                result.rejectValue("creditCardNumber", "payment.exception", null, null);
                return this.getCheckoutView();
            }
            return this.getConfirmationView(cart.getOrderNumber());
        }
        return this.getCartPageRedirect();
    }

    protected void copyShippingAddressToBillingAddress(Order order, BillingInfoForm billingInfoForm) {
        Address shipping;
        if (order.getFulfillmentGroups().get(0) != null && (shipping = ((FulfillmentGroup)order.getFulfillmentGroups().get(0)).getAddress()) != null) {
            AddressImpl billing = new AddressImpl();
            billing.setFirstName(shipping.getFirstName());
            billing.setLastName(shipping.getLastName());
            billing.setAddressLine1(shipping.getAddressLine1());
            billing.setAddressLine2(shipping.getAddressLine2());
            billing.setCity(shipping.getCity());
            billing.setState(shipping.getState());
            billing.setPostalCode(shipping.getPostalCode());
            billing.setCountry(shipping.getCountry());
            billing.setPrimaryPhone(shipping.getPrimaryPhone());
            billing.setEmailAddress(shipping.getEmailAddress());
            billingInfoForm.setAddress((Address)billing);
        }
    }

    protected boolean hasValidShippingAddresses(Order cart) {
        if (cart.getFulfillmentGroups() == null) {
            return false;
        }
        for (FulfillmentGroup fulfillmentGroup : cart.getFulfillmentGroups()) {
            if (fulfillmentGroup.getAddress() != null && fulfillmentGroup.getFulfillmentOption() != null) continue;
            return false;
        }
        return true;
    }

    protected boolean hasValidOrderInfo(Order cart) {
        return StringUtils.isNotBlank((String)cart.getEmailAddress());
    }

    protected void putFulfillmentOptionsAndEstimationOnModel(Model model) {
        List fulfillmentOptions = this.fulfillmentOptionService.readAllFulfillmentOptions();
        Order cart = CartState.getCart();
        if (!(cart instanceof NullOrderImpl) && cart.getFulfillmentGroups().size() > 0 && this.hasValidShippingAddresses(cart)) {
            HashSet options = new HashSet();
            options.addAll(fulfillmentOptions);
            FulfillmentEstimationResponse estimateResponse = null;
            try {
                estimateResponse = this.fulfillmentPricingService.estimateCostForFulfillmentGroup((FulfillmentGroup)cart.getFulfillmentGroups().get(0), options);
            }
            catch (FulfillmentPriceException e) {
                // empty catch block
            }
            model.addAttribute("estimateResponse", estimateResponse);
        }
        model.addAttribute("fulfillmentOptions", (Object)fulfillmentOptions);
    }

    protected List<String> populateExpirationMonths() {
        DateFormatSymbols dateFormatter;
        if (BroadleafRequestContext.hasLocale()) {
            Locale locale = BroadleafRequestContext.getBroadleafRequestContext().getJavaLocale();
            dateFormatter = new DateFormatSymbols(locale);
        } else {
            dateFormatter = new DateFormatSymbols();
        }
        ArrayList<String> expirationMonths = new ArrayList<String>();
        DecimalFormat formatter = new DecimalFormat("00");
        String[] months = dateFormatter.getMonths();
        for (int i = 1; i < months.length; ++i) {
            expirationMonths.add(formatter.format(i) + " - " + months[i - 1]);
        }
        return expirationMonths;
    }

    protected List<String> populateExpirationYears() {
        ArrayList<String> expirationYears = new ArrayList<String>();
        DateTime dateTime = new DateTime();
        for (int i = 0; i < 10; ++i) {
            expirationYears.add(dateTime.plusYears(i).getYear() + "");
        }
        return expirationYears;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(State.class, "address.state", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                State state = BroadleafCheckoutController.this.stateService.findStateByAbbreviation(text);
                this.setValue(state);
            }
        });
        binder.registerCustomEditor(Country.class, "address.country", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                Country country = BroadleafCheckoutController.this.countryService.findCountryByAbbreviation(text);
                this.setValue(country);
            }
        });
        binder.registerCustomEditor(Phone.class, "address.phonePrimary", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                if (!StringUtils.isBlank((String)text)) {
                    PhoneImpl phone = new PhoneImpl();
                    phone.setPhoneNumber(text);
                    this.setValue(phone);
                } else {
                    this.setValue(null);
                }
            }
        });
    }

    protected void populateModelWithShippingReferenceData(HttpServletRequest request, Model model) {
        String editOrderInfo = request.getParameter("edit-order-info");
        boolean hasValidOrderInfo = BooleanUtils.toBoolean((String)editOrderInfo) ? false : this.hasValidOrderInfo(CartState.getCart());
        model.addAttribute("validOrderInfo", (Object)hasValidOrderInfo);
        String editShipping = request.getParameter("edit-shipping");
        boolean hasValidShipping = BooleanUtils.toBoolean((String)editShipping) ? false : this.hasValidShippingAddresses(CartState.getCart());
        model.addAttribute("validShipping", (Object)hasValidShipping);
        this.putFulfillmentOptionsAndEstimationOnModel(model);
        model.addAttribute("states", (Object)this.stateService.findStates());
        model.addAttribute("countries", (Object)this.countryService.findCountries());
        model.addAttribute("expirationMonths", this.populateExpirationMonths());
        model.addAttribute("expirationYears", this.populateExpirationYears());
    }

    public String getCartPageRedirect() {
        return cartPageRedirect;
    }

    public String getCheckoutView() {
        return checkoutView;
    }

    public String getCheckoutPageRedirect() {
        return checkoutPageRedirect;
    }

    public String getMultishipView() {
        return multishipView;
    }

    public String getMultishipAddAddressView() {
        return multishipAddAddressView;
    }

    public String getMultishipSuccessView() {
        return multishipSuccessView;
    }

    public String getMultishipAddAddressSuccessView() {
        return multishipAddAddressSuccessView;
    }

    public String getBaseConfirmationView() {
        return baseConfirmationView;
    }

    protected String getConfirmationView(String orderNumber) {
        return this.getBaseConfirmationView() + "/" + orderNumber;
    }
}

