/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.security.MergeCartProcessor;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.controller.validator.RegisterCustomerValidator;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.broadleafcommerce.profile.web.core.form.RegisterCustomerForm;
import org.broadleafcommerce.profile.web.core.service.LoginService;
import org.springframework.security.core.Authentication;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;

public class BroadleafRegisterController
extends BroadleafAbstractController {
    protected boolean useEmailForLogin = true;
    protected static String registerSuccessView = "ajaxredirect:/";
    protected static String registerView = "authentication/register";
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    @Resource(name="blRegisterCustomerValidator")
    protected RegisterCustomerValidator registerCustomerValidator;
    @Resource(name="blMergeCartProcessor")
    protected MergeCartProcessor mergeCartProcessor;
    @Resource(name="blLoginService")
    protected LoginService loginService;

    public String register(RegisterCustomerForm registerCustomerForm, HttpServletRequest request, HttpServletResponse response, Model model) {
        String redirectUrl = request.getParameter("successUrl");
        if (StringUtils.isNotBlank((String)redirectUrl)) {
            registerCustomerForm.setRedirectUrl(redirectUrl);
        }
        return this.getRegisterView();
    }

    public String processRegister(RegisterCustomerForm registerCustomerForm, BindingResult errors, HttpServletRequest request, HttpServletResponse response, Model model) throws ServiceException {
        if (this.useEmailForLogin) {
            Customer customer = registerCustomerForm.getCustomer();
            customer.setUsername(customer.getEmailAddress());
        }
        this.registerCustomerValidator.validate((Object)registerCustomerForm, (Errors)errors, this.useEmailForLogin);
        if (!errors.hasErrors()) {
            Customer newCustomer = this.customerService.registerCustomer(registerCustomerForm.getCustomer(), registerCustomerForm.getPassword(), registerCustomerForm.getPasswordConfirm());
            assert (newCustomer != null);
            Authentication auth = this.loginService.loginCustomer(registerCustomerForm.getCustomer());
            this.mergeCartProcessor.execute(request, response, auth);
            String redirectUrl = registerCustomerForm.getRedirectUrl();
            if (StringUtils.isNotBlank((String)redirectUrl) && redirectUrl.contains(":")) {
                redirectUrl = null;
            }
            return StringUtils.isBlank((String)redirectUrl) ? this.getRegisterSuccessView() : "redirect:" + redirectUrl;
        }
        return this.getRegisterView();
    }

    public RegisterCustomerForm initCustomerRegistrationForm() {
        Customer customer = CustomerState.getCustomer();
        if (customer == null || !customer.isAnonymous()) {
            customer = this.customerService.createCustomerFromId(null);
        }
        RegisterCustomerForm customerRegistrationForm = new RegisterCustomerForm();
        customerRegistrationForm.setCustomer(customer);
        return customerRegistrationForm;
    }

    public boolean isUseEmailForLogin() {
        return this.useEmailForLogin;
    }

    public void setUseEmailForLogin(boolean useEmailForLogin) {
        this.useEmailForLogin = useEmailForLogin;
    }

    public String getRegisterSuccessView() {
        return registerSuccessView;
    }

    public String getRegisterView() {
        return registerView;
    }
}

