/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.BundleOrderItem;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.OrderItemPriceDetail;
import org.broadleafcommerce.core.order.domain.OrderItemQualifier;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemPriceDetailWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemQualifierWrapper;

@XmlRootElement(name="orderItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderItemWrapper
extends BaseWrapper
implements APIWrapper<OrderItem> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String name;
    @XmlElement
    protected Integer quantity;
    @XmlElement
    protected Money retailPrice;
    @XmlElement
    protected Money salePrice;
    @XmlElement
    protected Long orderId;
    @XmlElement
    protected Long categoryId;
    @XmlElement
    protected Long skuId;
    @XmlElement
    protected Long productId;
    protected Boolean isBundle = Boolean.FALSE;
    @XmlElement(name="orderItemAttribute")
    @XmlElementWrapper(name="orderItemAttributes")
    protected List<OrderItemAttributeWrapper> orderItemAttributes;
    @XmlElement(name="orderItemPriceDetails")
    @XmlElementWrapper(name="orderItemPriceDetails")
    protected List<OrderItemPriceDetailWrapper> orderItemPriceDetails;
    @XmlElement(name="bundleItem")
    @XmlElementWrapper(name="bundleItems")
    protected List<OrderItemWrapper> bundleItems;
    @XmlElementWrapper(name="qualifiers")
    @XmlElement(name="qualifier")
    protected List<OrderItemQualifierWrapper> qualifiers;

    @Override
    public void wrapDetails(OrderItem model, HttpServletRequest request) {
        this.id = model.getId();
        this.name = model.getName();
        this.quantity = model.getQuantity();
        this.orderId = model.getOrder().getId();
        this.retailPrice = model.getRetailPrice();
        this.salePrice = model.getSalePrice();
        if (model.getCategory() != null) {
            this.categoryId = model.getCategory().getId();
        }
        if (model.getOrderItemAttributes() != null && !model.getOrderItemAttributes().isEmpty()) {
            Map itemAttributes = model.getOrderItemAttributes();
            this.orderItemAttributes = new ArrayList<OrderItemAttributeWrapper>();
            Set keys = itemAttributes.keySet();
            for (String key : keys) {
                OrderItemAttributeWrapper orderItemAttributeWrapper = (OrderItemAttributeWrapper)this.context.getBean(OrderItemAttributeWrapper.class.getName());
                orderItemAttributeWrapper.wrapSummary((OrderItemAttribute)itemAttributes.get(key), request);
                this.orderItemAttributes.add(orderItemAttributeWrapper);
            }
        }
        if (model.getOrderItemPriceDetails() != null && !model.getOrderItemPriceDetails().isEmpty()) {
            this.orderItemPriceDetails = new ArrayList<OrderItemPriceDetailWrapper>();
            for (OrderItemPriceDetail orderItemPriceDetail : model.getOrderItemPriceDetails()) {
                OrderItemPriceDetailWrapper orderItemPriceDetailWrapper = (OrderItemPriceDetailWrapper)this.context.getBean(OrderItemPriceDetailWrapper.class.getName());
                orderItemPriceDetailWrapper.wrapSummary(orderItemPriceDetail, request);
                this.orderItemPriceDetails.add(orderItemPriceDetailWrapper);
            }
        }
        if (model instanceof DiscreteOrderItem) {
            DiscreteOrderItem doi = (DiscreteOrderItem)model;
            this.skuId = doi.getSku().getId();
            this.productId = doi.getProduct().getId();
            this.isBundle = false;
        } else if (model instanceof BundleOrderItem) {
            BundleOrderItem boi = (BundleOrderItem)model;
            this.skuId = boi.getSku().getId();
            this.productId = boi.getProduct().getId();
            this.isBundle = true;
            List discreteItems = boi.getDiscreteOrderItems();
            if (discreteItems != null && !discreteItems.isEmpty()) {
                this.bundleItems = new ArrayList<OrderItemWrapper>();
                for (DiscreteOrderItem doi : discreteItems) {
                    OrderItemWrapper doiWrapper = (OrderItemWrapper)this.context.getBean(OrderItemWrapper.class.getName());
                    doiWrapper.wrapSummary((OrderItem)doi, request);
                    this.bundleItems.add(doiWrapper);
                }
            }
        }
        if (model.getOrderItemQualifiers() != null && !model.getOrderItemQualifiers().isEmpty()) {
            this.qualifiers = new ArrayList<OrderItemQualifierWrapper>();
            for (OrderItemQualifier qualifier : model.getOrderItemQualifiers()) {
                OrderItemQualifierWrapper qualifierWrapper = (OrderItemQualifierWrapper)this.context.getBean(OrderItemQualifierWrapper.class.getName());
                qualifierWrapper.wrapSummary(qualifier, request);
                this.qualifiers.add(qualifierWrapper);
            }
        }
    }

    @Override
    public void wrapSummary(OrderItem model, HttpServletRequest request) {
        this.wrapDetails(model, request);
    }
}

