/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.endpoint.BaseEndpoint;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.core.web.order.CartState;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;

public abstract class CartEndpoint
extends BaseEndpoint {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;

    public OrderWrapper findCartForCustomer(HttpServletRequest request) {
        Order cart = CartState.getCart();
        if (cart != null) {
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
    }

    public OrderWrapper createNewCartForCustomer(HttpServletRequest request) {
        Order cart;
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer == null) {
            customer = this.customerService.createCustomerFromId(null);
        }
        if ((cart = this.orderService.findCartForCustomer(customer)) == null) {
            cart = this.orderService.createNewCartForCustomer(customer);
            CartState.setCart(cart);
        }
        OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
        wrapper.wrapDetails(cart, request);
        return wrapper;
    }

    public OrderWrapper addProductToOrder(HttpServletRequest request, UriInfo uriInfo, Long productId, Long categoryId, int quantity, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                MultivaluedMap multiValuedMap = uriInfo.getQueryParameters();
                HashMap<String, Object> productOptions = new HashMap<String, Object>();
                Set keySet = multiValuedMap.keySet();
                for (String key : keySet) {
                    if (multiValuedMap.getFirst((Object)key) == null || !key.startsWith("productOption.")) continue;
                    productOptions.put(StringUtils.removeStart((String)key, (String)"productOption."), multiValuedMap.getFirst((Object)key));
                }
                OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                orderItemRequestDTO.setProductId(productId);
                orderItemRequestDTO.setCategoryId(categoryId);
                orderItemRequestDTO.setQuantity(Integer.valueOf(quantity));
                if (productOptions.size() > 0) {
                    orderItemRequestDTO.setItemAttributes(productOptions);
                }
                Order order = this.orderService.addItem(cart.getId(), orderItemRequestDTO, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (PricingException e) {
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured pricing the order.").build());
            }
            catch (AddToCartException e) {
                if (e.getCause() != null) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)("" + e.getCause())).build());
                }
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)("An error occured adding the item to the cart." + e.getCause())).build());
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
    }

    public OrderWrapper removeItemFromOrder(HttpServletRequest request, Long itemId, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                Order order = this.orderService.removeItem(cart.getId(), itemId, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (PricingException e) {
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured pricing the cart.").build());
            }
            catch (RemoveFromCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Could not find order item id " + itemId)).build());
                }
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured removing the item to the cart.").build());
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
    }

    public OrderWrapper updateItemQuantity(HttpServletRequest request, Long itemId, Integer quantity, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart != null) {
            try {
                OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                orderItemRequestDTO.setOrderItemId(itemId);
                orderItemRequestDTO.setQuantity(quantity);
                Order order = this.orderService.updateItemQuantity(cart.getId(), orderItemRequestDTO, priceOrder);
                order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrapDetails(order, request);
                return wrapper;
            }
            catch (UpdateCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Could not find order item id " + itemId)).build());
                }
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured removing the item to the cart.").build());
            }
            catch (RemoveFromCartException e) {
                if (e.getCause() instanceof ItemNotFoundException) {
                    throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)("Could not find order item id " + itemId)).build());
                }
                throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured removing the item to the cart.").build());
            }
            catch (PricingException pe) {
                throw new WebApplicationException((Throwable)pe, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured pricing the cart.").build());
            }
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
    }

    public OrderWrapper addOfferCode(HttpServletRequest request, String promoCode, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
        }
        OfferCode offerCode = this.offerService.lookupOfferCodeByCode(promoCode);
        if (offerCode == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Offer Code could not be found").build());
        }
        try {
            cart = this.orderService.addOfferCode(cart, offerCode, priceOrder);
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        catch (PricingException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured pricing the cart.").build());
        }
        catch (OfferMaxUseExceededException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.BAD_REQUEST).type("text/plain").entity((Object)("The offer (promo) code provided has exceeded its max usages: " + promoCode)).build());
        }
    }

    public OrderWrapper removeOfferCode(HttpServletRequest request, String promoCode, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
        }
        OfferCode offerCode = this.offerService.lookupOfferCodeByCode(promoCode);
        if (offerCode == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Offer code was invalid or could not be found.").build());
        }
        try {
            cart = this.orderService.removeOfferCode(cart, offerCode, priceOrder);
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        catch (PricingException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured pricing the cart.").build());
        }
    }

    public OrderWrapper removeAllOfferCodes(HttpServletRequest request, boolean priceOrder) {
        Order cart = CartState.getCart();
        if (cart == null) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.NOT_FOUND).type("text/plain").entity((Object)"Cart could not be found").build());
        }
        try {
            cart = this.orderService.removeAllOfferCodes(cart, priceOrder);
            OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
            wrapper.wrapDetails(cart, request);
            return wrapper;
        }
        catch (PricingException e) {
            throw new WebApplicationException((Throwable)e, Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)"An error occured pricing the cart.").build());
        }
    }
}

