/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.order.domain.SkuAccessor;
import org.broadleafcommerce.core.order.service.OrderService;
import org.mortbay.log.Log;
import org.springframework.beans.factory.annotation.Value;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Macro;
import org.thymeleaf.dom.Node;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.element.AbstractElementProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class GoogleUniversalAnalyticsProcessor
extends AbstractElementProcessor {
    @Value(value="${googleAnalytics.masterWebPropertyId}")
    protected String masterWebPropertyId;
    @Value(value="${googleAnalytics.webPropertyId:}")
    protected String webPropertyId;
    @Value(value="${googleAnalytics.affiliation:}")
    protected String affiliation;
    @Value(value="${googleAnalytics.enableLinkAttribution:true}")
    protected boolean includeLinkAttribution;
    @Value(value="${googleAnalytics.enableDisplayAdvertising:false}")
    protected boolean includeDisplayAdvertising;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    protected boolean testLocal = false;

    public GoogleUniversalAnalyticsProcessor() {
        super("google_universal_analytics");
    }

    public GoogleUniversalAnalyticsProcessor(String elementName) {
        super(elementName);
    }

    public int getPrecedence() {
        return 0;
    }

    protected ProcessorResult processElement(Arguments arguments, Element element) {
        StringBuffer sb = new StringBuffer();
        Map<String, String> trackers = this.getTrackers();
        if (MapUtils.isNotEmpty(trackers)) {
            sb.append("<script>\n");
            sb.append("(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){");
            sb.append("(i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),");
            sb.append("m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)");
            sb.append("})(window,document,'script','//www.google-analytics.com/analytics.js','ga');");
            String orderNumberExpression = element.getAttributeValue("ordernumber");
            String orderNumber = (String)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)orderNumberExpression);
            Order order = null;
            if (orderNumber != null) {
                order = this.orderService.findOrderByOrderNumber(orderNumber);
            }
            for (Map.Entry<String, String> tracker : trackers.entrySet()) {
                String trackerName = tracker.getKey();
                String trackerPrefix = "";
                String id = tracker.getValue();
                sb.append("ga('create', '" + id + "', 'auto', {");
                if (!"webProperty".equals(trackerName)) {
                    trackerPrefix = trackerName + ".";
                    sb.append("'name': '" + trackerName + "'");
                    if (this.testLocal) {
                        sb.append(",");
                    }
                }
                if (this.testLocal) {
                    sb.append("'cookieDomain': 'none'");
                }
                sb.append("});");
                sb.append("ga('" + trackerPrefix + "send', 'pageview');");
                if (this.isIncludeLinkAttribution()) {
                    sb.append(this.getLinkAttributionJs(trackerPrefix));
                }
                if (this.isIncludeDisplayAdvertising()) {
                    sb.append(this.getDisplayAdvertisingJs(trackerPrefix));
                }
                if (order == null) continue;
                sb.append(this.getTransactionJs(order, trackerPrefix));
            }
            sb.append("</script>");
            Macro contentNode = new Macro(sb.toString());
            element.clearChildren();
            element.getParent().insertAfter((Node)element, (Node)contentNode);
            element.getParent().removeChild((Node)element);
        } else {
            Log.warn((String)"No trackers were found, not outputting Google Analytics script. Set the googleAnalytics.webPropertyId and/or the googleAnalytics.masterWebPropertyId system properties to output Google Analytics");
        }
        return ProcessorResult.OK;
    }

    protected Map<String, String> getTrackers() {
        HashMap<String, String> trackers = new HashMap<String, String>();
        if (this.shouldShowMasterTracker()) {
            trackers.put("master", this.getMasterWebPropertyId());
        }
        if (StringUtils.isNotBlank((CharSequence)this.getWebPropertyId())) {
            trackers.put("webProperty", this.getWebPropertyId());
        }
        return trackers;
    }

    protected boolean shouldShowMasterTracker() {
        String masterWebPropertyId = this.getMasterWebPropertyId();
        return StringUtils.isNotBlank((CharSequence)masterWebPropertyId) && !"UA-XXXXXXX-X".equals(masterWebPropertyId);
    }

    protected String getLinkAttributionJs(String trackerPrefix) {
        return "ga('" + trackerPrefix + "require', 'linkid', 'linkid.js');";
    }

    protected String getDisplayAdvertisingJs(String trackerPrefix) {
        return "ga('" + trackerPrefix + "require', 'displayfeatures');";
    }

    protected String getTransactionJs(Order order, String trackerPrefix) {
        StringBuffer sb = new StringBuffer();
        sb.append("ga('" + trackerPrefix + "require', 'ecommerce', 'ecommerce.js');");
        sb.append("ga('" + trackerPrefix + "ecommerce:addTransaction', {");
        sb.append("'id': '" + order.getOrderNumber() + "'");
        if (StringUtils.isNotBlank((CharSequence)this.affiliation)) {
            sb.append(",'affiliation': '" + this.affiliation + "'");
        }
        sb.append(",'revenue': '" + order.getTotal() + "'");
        sb.append(",'shipping':'" + order.getTotalShipping() + "'");
        sb.append(",'tax': '" + order.getTotalTax() + "'");
        if (order.getCurrency() != null) {
            sb.append(",'currency': '" + order.getCurrency().getCurrencyCode() + "'");
        }
        sb.append("});");
        sb.append(this.getItemJs(order, trackerPrefix));
        sb.append("ga('" + trackerPrefix + "ecommerce:send');");
        return sb.toString();
    }

    protected String getItemJs(Order order, String trackerPrefix) {
        StringBuffer sb = new StringBuffer();
        for (FulfillmentGroup fulfillmentGroup : order.getFulfillmentGroups()) {
            for (FulfillmentGroupItem fulfillmentGroupItem : fulfillmentGroup.getFulfillmentGroupItems()) {
                OrderItem orderItem = fulfillmentGroupItem.getOrderItem();
                Sku sku = ((SkuAccessor)orderItem).getSku();
                sb.append("ga('" + trackerPrefix + "ecommerce:addItem', {");
                sb.append("'id': '" + order.getOrderNumber() + "'");
                sb.append(",'name': '" + sku.getName() + "'");
                sb.append(",'sku': '" + sku.getId() + "'");
                sb.append(",'category': '" + this.getVariation(orderItem) + "'");
                sb.append(",'price': '" + orderItem.getAveragePrice() + "'");
                sb.append(",'quantity': '" + orderItem.getQuantity() + "'");
                sb.append("});");
            }
        }
        return sb.toString();
    }

    protected String getVariation(OrderItem item) {
        if (MapUtils.isEmpty((Map)item.getOrderItemAttributes())) {
            return item.getCategory() == null ? "" : item.getCategory().getName();
        }
        String result = "";
        for (Map.Entry entry : item.getOrderItemAttributes().entrySet()) {
            result = result + (String)((Object)((OrderItemAttribute)entry.getValue()).getValue()) + " ";
        }
        return result.substring(0, result.length() - 1);
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    public void setOrderService(OrderService orderService) {
        this.orderService = orderService;
    }

    public String getMasterWebPropertyId() {
        return this.masterWebPropertyId;
    }

    public void setMasterWebPropertyId(String masterWebPropertyId) {
        this.masterWebPropertyId = masterWebPropertyId;
    }

    public String getAffiliation() {
        return this.affiliation;
    }

    public void setAffiliation(String affiliation) {
        this.affiliation = affiliation;
    }

    public String getWebPropertyId() {
        return this.webPropertyId;
    }

    public void setWebPropertyId(String webPropertyId) {
        this.webPropertyId = webPropertyId;
    }

    public boolean isIncludeLinkAttribution() {
        return this.includeLinkAttribution;
    }

    public void setIncludeLinkAttribution(boolean includeLinkAttribution) {
        this.includeLinkAttribution = includeLinkAttribution;
    }

    public boolean isIncludeDisplayAdvertising() {
        return this.includeDisplayAdvertising;
    }

    public void setIncludeDisplayAdvertising(boolean includeDisplayAdvertising) {
        this.includeDisplayAdvertising = includeDisplayAdvertising;
    }
}

