/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryXref;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

@Component(value="blCategoriesProcessor")
public class CategoriesProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blCatalogService")
    protected CatalogService catalogService;

    public CategoriesProcessor() {
        super("categories");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        String resultVar = element.getAttributeValue("resultVar");
        String parentCategory = element.getAttributeValue("parentCategory");
        String unparsedMaxResults = element.getAttributeValue("maxResults");
        List categories = this.catalogService.findCategoriesByName(parentCategory);
        if (categories != null && categories.size() > 0) {
            List subcategories = ((Category)categories.get(0)).getChildCategoryXrefs();
            List results = Collections.emptyList();
            if (subcategories != null && !subcategories.isEmpty()) {
                results = new ArrayList(subcategories.size());
                if (StringUtils.isNotEmpty((String)unparsedMaxResults)) {
                    int maxResults = Integer.parseInt(unparsedMaxResults);
                    if (subcategories.size() > maxResults) {
                        subcategories = subcategories.subList(0, maxResults);
                    }
                }
                for (CategoryXref xref : subcategories) {
                    results.add(xref.getSubCategory());
                }
            }
            this.addToModel(arguments, resultVar, results);
        }
    }
}

