/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component(value="blAuthenticationSuccessHandler")
public class BroadleafAuthenticationSuccessHandler
extends SavedRequestAwareAuthenticationSuccessHandler {
    protected static final String SESSION_ATTR = "SFP-ActiveID";

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws ServletException, IOException {
        String targetUrl = request.getParameter(this.getTargetUrlParameter());
        request.getSession().removeAttribute(SESSION_ATTR);
        if (StringUtils.isNotBlank((String)targetUrl) && targetUrl.contains(":")) {
            this.getRedirectStrategy().sendRedirect(request, response, this.getDefaultTargetUrl());
        } else {
            super.onAuthenticationSuccess(request, response, authentication);
        }
    }
}

