/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.checkout.validator;

import org.apache.commons.validator.EmailValidator;
import org.broadleafcommerce.core.web.checkout.model.OrderInfoForm;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;

@Component(value="blOrderInfoFormValidator")
public class OrderInfoFormValidator
implements Validator {
    public boolean supports(Class clazz) {
        return clazz.equals(OrderInfoFormValidator.class);
    }

    public void validate(Object obj, Errors errors) {
        OrderInfoForm orderInfoForm = (OrderInfoForm)obj;
        ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"emailAddress", (String)"emailAddress.required");
        if (!errors.hasErrors() && !EmailValidator.getInstance().isValid(orderInfoForm.getEmailAddress())) {
            errors.rejectValue("emailAddress", "emailAddress.invalid", null, null);
        }
    }
}

