/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.search.domain.ProductSearchCriteria;
import org.broadleafcommerce.core.search.domain.SearchFacetResultDTO;
import org.broadleafcommerce.core.web.service.SearchFacetDTOService;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

@Component(value="blToggleFacetLinkProcessor")
public class ToggleFacetLinkProcessor
extends AbstractAttributeModifierAttrProcessor {
    @Resource(name="blSearchFacetDTOService")
    protected SearchFacetDTOService facetService;

    public ToggleFacetLinkProcessor() {
        super("togglefacetlink");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        BroadleafRequestContext blcContext = BroadleafRequestContext.getBroadleafRequestContext();
        HttpServletRequest request = blcContext.getRequest();
        String baseUrl = request.getRequestURL().toString();
        HashMap<String, String[]> params = new HashMap<String, String[]>(request.getParameterMap());
        SearchFacetResultDTO result = (SearchFacetResultDTO)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
        String key = this.facetService.getUrlKey(result);
        String value = this.facetService.getValue(result);
        Object[] paramValues = (String[])params.get(key);
        paramValues = ArrayUtils.contains((Object[])paramValues, (Object)this.facetService.getValue(result)) ? (String[])ArrayUtils.removeElement((Object[])paramValues, (Object)this.facetService.getValue(result)) : (String[])ArrayUtils.add((Object[])paramValues, (Object)value);
        params.remove(ProductSearchCriteria.PAGE_NUMBER);
        params.put(key, (String[])paramValues);
        String url = ProcessorUtils.getUrl(baseUrl, params);
        attrs.put("href", url);
        return attrs;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

