/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import javax.annotation.Resource;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.order.domain.NullOrderImpl;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

@Component(value="blNamedOrderProcessor")
public class NamedOrderProcessor
extends AbstractModelVariableModifierProcessor {
    @Resource(name="blOrderService")
    protected OrderService orderService;

    public NamedOrderProcessor() {
        super("named_order");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        Customer customer = CustomerState.getCustomer();
        String orderVar = element.getAttributeValue("orderVar");
        String orderName = element.getAttributeValue("orderName");
        Order order = this.orderService.findNamedOrderForCustomer(orderName, customer);
        if (order != null) {
            this.addToModel(arguments, orderVar, order);
        } else {
            this.addToModel(arguments, orderVar, new NullOrderImpl());
        }
    }
}

