/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.service;

import java.util.ArrayList;
import java.util.List;
import org.broadleafcommerce.common.currency.domain.BroadleafCurrency;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.web.service.UpdateCartServiceExtensionListener;

public class UpdateCartServiceExtensionManager
implements UpdateCartServiceExtensionListener {
    protected List<UpdateCartServiceExtensionListener> listeners = new ArrayList<UpdateCartServiceExtensionListener>();

    @Override
    public void validateCart(Order cart) {
        for (UpdateCartServiceExtensionListener listener : this.listeners) {
            listener.validateCart(cart);
        }
    }

    @Override
    public Boolean isAvailable(DiscreteOrderItem doi, BroadleafCurrency currency) {
        boolean available = true;
        for (UpdateCartServiceExtensionListener listener : this.listeners) {
            available = available && listener.isAvailable(doi, currency) != false;
        }
        return available;
    }

    public List<UpdateCartServiceExtensionListener> getListeners() {
        return this.listeners;
    }

    public void setListeners(List<UpdateCartServiceExtensionListener> listeners) {
        this.listeners = listeners;
    }
}

