/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.security.MergeCartProcessor;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.MergeCartService;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.MergeCartResponse;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Component;

@Component(value="blMergeCartProcessor")
public class MergeCartProcessorImpl
implements MergeCartProcessor {
    private String mergeCartResponseKey = "bl_merge_cart_response";
    @Resource(name="blCustomerService")
    private CustomerService customerService;
    @Resource(name="blOrderService")
    private OrderService orderService;
    @Resource(name="blMergeCartService")
    private MergeCartService mergeCartService;

    public void execute(HttpServletRequest request, HttpServletResponse response, Authentication authResult) {
        MergeCartResponse mergeCartResponse;
        Customer loggedInCustomer = this.customerService.readCustomerByUsername(authResult.getName());
        Customer anonymousCustomer = (Customer)request.getSession(true).getAttribute("_blc_anonymousCustomer");
        Order cart = null;
        if (anonymousCustomer != null) {
            cart = this.orderService.findCartForCustomer(anonymousCustomer);
        }
        try {
            mergeCartResponse = this.mergeCartService.mergeCart(loggedInCustomer, cart);
        }
        catch (PricingException e) {
            throw new RuntimeException(e);
        }
        catch (RemoveFromCartException e) {
            throw new RuntimeException(e);
        }
        request.getSession().setAttribute(this.mergeCartResponseKey, (Object)mergeCartResponse);
    }

    public String getMergeCartResponseKey() {
        return this.mergeCartResponseKey;
    }

    public void setMergeCartResponseKey(String mergeCartResponseKey) {
        this.mergeCartResponseKey = mergeCartResponseKey;
    }
}

