/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.order.security;

import java.io.IOException;
import java.util.HashMap;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.UpdateCartResponse;
import org.broadleafcommerce.core.web.service.UpdateCartService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.security.CustomerStateFilter;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Component(value="blCartStateFilter")
public class CartStateFilter
extends GenericFilterBean
implements Ordered {
    protected final Log LOG = LogFactory.getLog(((Object)((Object)this)).getClass());
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    protected static boolean copyCartWhenSpecifiedStateChanges = false;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blUpdateCartService")
    protected UpdateCartService updateCartService;
    private static String cartRequestAttributeName = "cart";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        Customer customer = (Customer)request.getAttribute(CustomerStateFilter.getCustomerRequestAttributeName());
        if (customer != null) {
            Order cart;
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace((Object)("Looking up cart for customer " + customer.getId()));
            }
            if ((cart = this.orderService.findCartForCustomer(customer)) == null) {
                cart = this.orderService.getNullOrder();
            } else {
                try {
                    this.updateCartService.validateCart(cart);
                }
                catch (IllegalArgumentException e) {
                    if (copyCartWhenSpecifiedStateChanges) {
                        UpdateCartResponse updateCartResponse = this.updateCartService.copyCartToCurrentContext(cart);
                        request.setAttribute("updateCartResponse", (Object)updateCartResponse);
                    }
                    this.orderService.cancelOrder(cart);
                    cart = this.orderService.createNewCartForCustomer(customer);
                }
            }
            request.setAttribute(cartRequestAttributeName, (Object)cart);
            HashMap<String, Order> ruleMap = (HashMap<String, Order>)request.getAttribute(BLC_RULE_MAP_PARAM);
            if (ruleMap == null) {
                ruleMap = new HashMap<String, Order>();
            }
            ruleMap.put("cart", cart);
            request.setAttribute(BLC_RULE_MAP_PARAM, ruleMap);
        }
        chain.doFilter(request, response);
    }

    public int getOrder() {
        return 1502;
    }

    public static String getCartRequestAttributeName() {
        return cartRequestAttributeName;
    }

    public static void setCartRequestAttributeName(String cartRequestAttributeName) {
        CartStateFilter.cartRequestAttributeName = cartRequestAttributeName;
    }
}

