/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.controller.account.AbstractAccountController;
import org.broadleafcommerce.core.web.order.model.AddToCartItem;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.ui.Model;

public class BroadleafManageWishlistController
extends AbstractAccountController {
    protected static String accountWishlistView = "account/manageWishlist";
    protected static String accountWishlistRedirect = "redirect:/account/wishlist";

    public String add(HttpServletRequest request, HttpServletResponse response, Model model, AddToCartItem itemRequest, String wishlistName) throws IOException, AddToCartException, PricingException {
        Order wishlist = this.orderService.findNamedOrderForCustomer(wishlistName, CustomerState.getCustomer((HttpServletRequest)request));
        if (wishlist == null) {
            wishlist = this.orderService.createNamedOrderForCustomer(wishlistName, CustomerState.getCustomer((HttpServletRequest)request));
        }
        wishlist = this.orderService.addItem(wishlist.getId(), (OrderItemRequestDTO)itemRequest, true);
        return this.getAccountWishlistRedirect();
    }

    public String viewWishlist(HttpServletRequest request, HttpServletResponse response, Model model, String wishlistName) {
        Order wishlist = this.orderService.findNamedOrderForCustomer(wishlistName, CustomerState.getCustomer());
        model.addAttribute("wishlist", (Object)wishlist);
        return this.getAccountWishlistView();
    }

    public String removeItemFromWishlist(HttpServletRequest request, HttpServletResponse response, Model model, String wishlistName, Long itemId) throws RemoveFromCartException {
        Order wishlist = this.orderService.findNamedOrderForCustomer(wishlistName, CustomerState.getCustomer());
        this.orderService.removeItem(wishlist.getId(), itemId, false);
        model.addAttribute("wishlist", (Object)wishlist);
        return this.getAccountWishlistRedirect();
    }

    public String moveItemToCart(HttpServletRequest request, HttpServletResponse response, Model model, String wishlistName, Long orderItemId) throws RemoveFromCartException, AddToCartException {
        Order wishlist = this.orderService.findNamedOrderForCustomer(wishlistName, CustomerState.getCustomer());
        List orderItems = wishlist.getOrderItems();
        OrderItem orderItem = null;
        for (OrderItem item : orderItems) {
            if (!orderItemId.equals(item.getId())) continue;
            orderItem = item;
            break;
        }
        if (orderItem == null) {
            throw new IllegalArgumentException("The item id provided was not found in the wishlist");
        }
        this.orderService.addItemFromNamedOrder(wishlist, orderItem, true);
        model.addAttribute("wishlist", (Object)wishlist);
        return this.getAccountWishlistRedirect();
    }

    public String moveListToCart(HttpServletRequest request, HttpServletResponse response, Model model, String wishlistName) throws RemoveFromCartException, AddToCartException {
        Order wishlist = this.orderService.findNamedOrderForCustomer(wishlistName, CustomerState.getCustomer());
        this.orderService.addAllItemsFromNamedOrder(wishlist, true);
        model.addAttribute("wishlist", (Object)wishlist);
        return this.getAccountWishlistRedirect();
    }

    public String getAccountWishlistView() {
        return accountWishlistView;
    }

    public String getAccountWishlistRedirect() {
        return accountWishlistRedirect;
    }
}

