/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.payment.service.type.PaymentInfoType;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AddressWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AmountItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.MapElementWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PhoneWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="paymentInfo")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class PaymentInfoWrapper
extends BaseWrapper
implements APIWrapper<PaymentInfo>,
APIUnwrapper<PaymentInfo> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Long orderId;
    @XmlElement
    protected String type;
    @XmlElement
    protected AddressWrapper address;
    @XmlElement
    protected PhoneWrapper phone;
    @XmlElement(name="element")
    @XmlElementWrapper(name="additionalFields")
    protected List<MapElementWrapper> additionalFields;
    @XmlElement
    protected Money amount;
    @XmlElement(name="amountItem")
    @XmlElementWrapper(name="amountItems")
    protected List<AmountItemWrapper> amountItems;
    @XmlElement
    protected String customerIpAddress;
    @XmlElement
    protected String referenceNumber;

    @Override
    public void wrap(PaymentInfo model, HttpServletRequest request) {
        this.id = model.getId();
        if (model.getOrder() != null) {
            this.orderId = model.getOrder().getId();
        }
        if (model.getType() != null) {
            this.type = model.getType().getType();
        }
        if (model.getAddress() != null) {
            AddressWrapper addressWrapper = (AddressWrapper)this.context.getBean(AddressWrapper.class.getName());
            addressWrapper.wrap(model.getAddress(), request);
            this.address = addressWrapper;
        }
        if (model.getPhone() != null) {
            PhoneWrapper phoneWrapper = (PhoneWrapper)this.context.getBean(PhoneWrapper.class.getName());
            phoneWrapper.wrap(model.getPhone(), request);
            this.phone = phoneWrapper;
        }
        if (model.getAdditionalFields() != null && !model.getAdditionalFields().isEmpty()) {
            ArrayList<MapElementWrapper> mapElementWrappers = new ArrayList<MapElementWrapper>();
            for (String key : model.getAdditionalFields().keySet()) {
                MapElementWrapper mapElementWrapper = new MapElementWrapper();
                mapElementWrapper.setKey(key);
                mapElementWrapper.setValue(model.getAdditionalFields().get(key));
                mapElementWrappers.add(mapElementWrapper);
            }
            this.additionalFields = mapElementWrappers;
        }
        this.amount = model.getAmount();
        if (model.getAmountItems() != null) {
            ArrayList<AmountItemWrapper> wrappers = new ArrayList<AmountItemWrapper>();
            for (AmountItem amountItem : model.getAmountItems()) {
                AmountItemWrapper amountItemWrapper = (AmountItemWrapper)this.context.getBean(AmountItemWrapper.class.getName());
                amountItemWrapper.wrap(amountItem, request);
                wrappers.add(amountItemWrapper);
            }
            this.amountItems = wrappers;
        }
        this.customerIpAddress = model.getCustomerIpAddress();
        this.referenceNumber = model.getReferenceNumber();
    }

    @Override
    public PaymentInfo unwrap(HttpServletRequest request, ApplicationContext context) {
        PaymentInfoService paymentInfoService = (PaymentInfoService)context.getBean("blPaymentInfoService");
        PaymentInfo paymentInfo = paymentInfoService.create();
        OrderService orderService = (OrderService)context.getBean("blOrderService");
        Order order = orderService.findOrderById(this.orderId);
        paymentInfo.setOrder(order);
        paymentInfo.setType(PaymentInfoType.getInstance((String)this.type));
        if (this.address != null) {
            paymentInfo.setAddress(this.address.unwrap(request, context));
        }
        if (this.phone != null) {
            paymentInfo.setPhone(this.phone.unwrap(request, context));
        }
        if (this.additionalFields != null && !this.additionalFields.isEmpty()) {
            HashMap<String, String> fields = new HashMap<String, String>();
            for (MapElementWrapper mapElementWrapper : this.additionalFields) {
                fields.put(mapElementWrapper.getKey(), mapElementWrapper.getValue().toString());
            }
            paymentInfo.setAdditionalFields(fields);
        }
        paymentInfo.setAmount(this.amount);
        paymentInfo.setCustomerIpAddress(this.customerIpAddress);
        paymentInfo.setReferenceNumber(this.referenceNumber);
        return paymentInfo;
    }
}

