/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.HashMap;
import java.util.Set;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.broadleafcommerce.core.offer.domain.OfferCode;
import org.broadleafcommerce.core.offer.service.OfferService;
import org.broadleafcommerce.core.offer.service.exception.OfferMaxUseExceededException;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.OrderItemRequestDTO;
import org.broadleafcommerce.core.order.service.exception.AddToCartException;
import org.broadleafcommerce.core.order.service.exception.ItemNotFoundException;
import org.broadleafcommerce.core.order.service.exception.RemoveFromCartException;
import org.broadleafcommerce.core.order.service.exception.UpdateCartException;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.core.service.CustomerService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="blRestCartEndpoint")
@Scope(value="singleton")
@Path(value="/cart/")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class CartEndpoint
implements ApplicationContextAware {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    @Resource(name="blOfferService")
    protected OfferService offerService;
    @Resource(name="blCustomerService")
    protected CustomerService customerService;
    protected ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @GET
    public OrderWrapper findCartForCustomer(@Context HttpServletRequest request) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                wrapper.wrap(cart, request);
                return wrapper;
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    public OrderWrapper createNewCartForCustomer(@Context HttpServletRequest request) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer == null) {
            customer = this.customerService.createCustomerFromId(null);
        }
        Order cart = this.orderService.createNewCartForCustomer(customer);
        OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
        wrapper.wrap(cart, request);
        return wrapper;
    }

    @POST
    @Path(value="{categoryId}/{productId}")
    public OrderWrapper addSkuToOrder(@Context HttpServletRequest request, @Context UriInfo uriInfo, @PathParam(value="categoryId") Long categoryId, @PathParam(value="productId") Long productId, @QueryParam(value="skuId") Long skuId, @QueryParam(value="quantity") @DefaultValue(value="1") int quantity, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    MultivaluedMap multiValuedMap = uriInfo.getQueryParameters();
                    HashMap<String, Object> productOptions = new HashMap<String, Object>();
                    Set keySet = multiValuedMap.keySet();
                    for (String key : keySet) {
                        if (multiValuedMap.getFirst((Object)key) == null) continue;
                        productOptions.put(key, multiValuedMap.getFirst((Object)key));
                    }
                    productOptions.remove("categoryId");
                    productOptions.remove("productId");
                    productOptions.remove("skuId");
                    productOptions.remove("quantity");
                    productOptions.remove("priceOrder");
                    if (skuId == null && productOptions.size() == 0) {
                        throw new WebApplicationException(Response.Status.BAD_REQUEST);
                    }
                    OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                    orderItemRequestDTO.setCategoryId(categoryId);
                    orderItemRequestDTO.setProductId(productId);
                    orderItemRequestDTO.setSkuId(skuId);
                    orderItemRequestDTO.setCategoryId(categoryId);
                    orderItemRequestDTO.setQuantity(Integer.valueOf(quantity));
                    if (productOptions.size() > 0) {
                        orderItemRequestDTO.setItemAttributes(productOptions);
                    }
                    Order order = this.orderService.addItem(cart.getId(), orderItemRequestDTO, priceOrder);
                    order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(order, request);
                    return wrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (AddToCartException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="items/{itemId}")
    public OrderWrapper removeItemFromOrder(@Context HttpServletRequest request, @PathParam(value="itemId") Long itemId, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    Order order = this.orderService.removeItem(cart.getId(), itemId, priceOrder);
                    order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(order, request);
                    return wrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (RemoveFromCartException e) {
                    if (e.getCause() instanceof ItemNotFoundException) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    throw new WebApplicationException(Response.Status.NOT_FOUND);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @PUT
    @Path(value="items/{itemId}")
    public OrderWrapper updateItemQuantity(@Context HttpServletRequest request, @PathParam(value="itemId") Long itemId, @QueryParam(value="quantity") Integer quantity, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    OrderItemRequestDTO orderItemRequestDTO = new OrderItemRequestDTO();
                    orderItemRequestDTO.setOrderItemId(itemId);
                    orderItemRequestDTO.setQuantity(quantity);
                    Order order = this.orderService.updateItemQuantity(cart.getId(), orderItemRequestDTO, priceOrder);
                    order = this.orderService.save(order, Boolean.valueOf(priceOrder));
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(order, request);
                    return wrapper;
                }
                catch (UpdateCartException e) {
                    if (e.getCause() instanceof ItemNotFoundException) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (RemoveFromCartException e) {
                    if (e.getCause() instanceof ItemNotFoundException) {
                        throw new WebApplicationException(Response.Status.NOT_FOUND);
                    }
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (PricingException pe) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    @Path(value="offer")
    public OrderWrapper addOfferCode(@Context HttpServletRequest request, @QueryParam(value="promoCode") String promoCode, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            OfferCode offerCode = this.offerService.lookupOfferCodeByCode(promoCode);
            if (cart != null && offerCode != null) {
                try {
                    cart = this.orderService.addOfferCode(cart, offerCode, priceOrder);
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(cart, request);
                    return wrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
                catch (OfferMaxUseExceededException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="offer")
    public OrderWrapper removeOfferCode(@Context HttpServletRequest request, @QueryParam(value="promoCode") String promoCode, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            OfferCode offerCode = this.offerService.lookupOfferCodeByCode(promoCode);
            if (cart != null && offerCode != null) {
                try {
                    cart = this.orderService.removeOfferCode(cart, offerCode, priceOrder);
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(cart, request);
                    return wrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @DELETE
    @Path(value="offers")
    public OrderWrapper removeAllOfferCodes(@Context HttpServletRequest request, @QueryParam(value="priceOrder") @DefaultValue(value="true") boolean priceOrder) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    cart = this.orderService.removeAllOfferCodes(cart, priceOrder);
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(cart, request);
                    return wrapper;
                }
                catch (PricingException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }
}

