/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.math.BigDecimal;
import org.broadleafcommerce.common.money.Money;
import org.springframework.stereotype.Component;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractTextChildModifierAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

@Component(value="blPriceTextDisplayProcessor")
public class PriceTextDisplayProcessor
extends AbstractTextChildModifierAttrProcessor {
    public PriceTextDisplayProcessor() {
        super("price");
    }

    public int getPrecedence() {
        return 1500;
    }

    protected String getText(Arguments arguments, Element element, String attributeName) {
        Money price;
        try {
            price = (Money)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
        }
        catch (ClassCastException e) {
            BigDecimal value = (BigDecimal)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
            price = new Money(value);
        }
        if (price == null || price.isZero()) {
            return "$0.00";
        }
        return "$" + price.getAmount().toString();
    }
}

