/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.DiscreteOrderItem;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.order.domain.OrderItemAttribute;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CategoryWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;

@XmlRootElement(name="orderItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderItemWrapper
extends BaseWrapper
implements APIWrapper<OrderItem> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String name;
    @XmlElement
    protected Integer quantity;
    @XmlElement
    protected Money retailPrice;
    @XmlElement
    protected Money salePrice;
    @XmlElement
    protected CategoryWrapper category;
    @XmlElement
    protected Long orderId;
    @XmlElement
    protected SkuWrapper sku;
    @XmlElement
    protected ProductWrapper product;
    @XmlElement(name="orderItemAttribute")
    @XmlElementWrapper(name="orderItemAttributes")
    protected List<OrderItemAttributeWrapper> orderItemAttributes;

    @Override
    public void wrap(OrderItem model, HttpServletRequest request) {
        this.id = model.getId();
        this.name = model.getName();
        this.quantity = model.getQuantity();
        this.retailPrice = model.getRetailPrice();
        this.salePrice = model.getSalePrice();
        if (model.getCategory() != null) {
            CategoryWrapper categoryWrapper = (CategoryWrapper)this.context.getBean(CategoryWrapper.class.getName());
            categoryWrapper.wrap(model.getCategory(), request);
            this.category = categoryWrapper;
        }
        this.orderId = model.getOrder().getId();
        Map itemAttributes = model.getOrderItemAttributes();
        if (itemAttributes != null && !itemAttributes.isEmpty()) {
            this.orderItemAttributes = new ArrayList<OrderItemAttributeWrapper>();
            Set keys = itemAttributes.keySet();
            for (String key : keys) {
                OrderItemAttributeWrapper orderItemAttributeWrapper = (OrderItemAttributeWrapper)this.context.getBean(OrderItemAttributeWrapper.class.getName());
                orderItemAttributeWrapper.wrap((OrderItemAttribute)itemAttributes.get(key), request);
                this.orderItemAttributes.add(orderItemAttributeWrapper);
            }
        }
        if (model instanceof DiscreteOrderItem) {
            DiscreteOrderItem doi = (DiscreteOrderItem)model;
            SkuWrapper skuWrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
            skuWrapper.wrap(doi.getSku(), request);
            this.sku = skuWrapper;
            ProductWrapper productWrapper = (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
            productWrapper.wrap(doi.getProduct(), request);
            this.product = productWrapper;
        }
    }
}

