/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.order;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="blRestOrderHistoryEndpoint")
@Scope(value="singleton")
@Path(value="/orders/")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class OrderHistoryEndpoint
implements ApplicationContextAware {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    protected ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @GET
    public List<OrderWrapper> findOrdersForCustomer(@Context HttpServletRequest request, @QueryParam(value="orderStatus") @DefaultValue(value="SUBMITTED") String orderStatus) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        OrderStatus status = OrderStatus.getInstance((String)orderStatus);
        if (customer != null && status != null) {
            List orders = this.orderService.findOrdersForCustomer(customer, status);
            if (orders != null && !orders.isEmpty()) {
                ArrayList<OrderWrapper> wrappers = new ArrayList<OrderWrapper>();
                for (Order order : orders) {
                    OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                    wrapper.wrap(order, request);
                    wrappers.add(wrapper);
                }
                return wrappers;
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }
}

