/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.catalog;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.CategoryAttribute;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductAttribute;
import org.broadleafcommerce.core.catalog.domain.ProductBundle;
import org.broadleafcommerce.core.catalog.domain.RelatedProduct;
import org.broadleafcommerce.core.catalog.domain.Sku;
import org.broadleafcommerce.core.catalog.domain.SkuAttribute;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.media.domain.Media;
import org.broadleafcommerce.core.web.api.wrapper.CategoriesWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CategoryAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CategoryWrapper;
import org.broadleafcommerce.core.web.api.wrapper.MediaWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductBundleWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.RelatedProductWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuAttributeWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="blRestCatalogEndpoint")
@Scope(value="singleton")
@Path(value="/catalog/")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class CatalogEndpoint
implements ApplicationContextAware {
    @Resource(name="blCatalogService")
    private CatalogService catalogService;
    private ApplicationContext context;
    private StaticAssetService staticAssetService;

    @GET
    @Path(value="product/{id}")
    public ProductWrapper findProductById(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ProductWrapper wrapper = product instanceof ProductBundle ? (ProductWrapper)this.context.getBean(ProductBundleWrapper.class.getName()) : (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
            wrapper.wrap(product, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="products")
    public List<ProductWrapper> findProductsByName(@Context HttpServletRequest request, @QueryParam(value="name") String name, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) {
        List result = name == null ? this.catalogService.findAllProducts(limit, offset) : this.catalogService.findProductsByName(name, limit, offset);
        ArrayList<ProductWrapper> out = new ArrayList<ProductWrapper>();
        if (result != null) {
            for (Product product : result) {
                ProductWrapper wrapper = product instanceof ProductBundle ? (ProductWrapper)this.context.getBean(ProductBundleWrapper.class.getName()) : (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
                wrapper.wrap(product, request);
                out.add(wrapper);
            }
        }
        return out;
    }

    @GET
    @Path(value="product/{id}/skus")
    public List<SkuWrapper> findSkusByProductById(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            List skus = product.getAllSkus();
            ArrayList<SkuWrapper> out = new ArrayList<SkuWrapper>();
            if (skus != null) {
                for (Sku sku : skus) {
                    SkuWrapper wrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
                    wrapper.wrap(sku, request);
                    out.add(wrapper);
                }
                return out;
            }
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="product/{id}/defaultSku")
    public SkuWrapper findDefaultSkuByProductId(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null && product.getDefaultSku() != null) {
            SkuWrapper wrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
            wrapper.wrap(product.getDefaultSku(), request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="categories")
    public CategoriesWrapper findAllCategories(@Context HttpServletRequest request, @QueryParam(value="name") String name, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) {
        List categories = name != null ? this.catalogService.findCategoriesByName(name, limit, offset) : this.catalogService.findAllCategories(limit, offset);
        CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
        wrapper.wrap(categories, request);
        return wrapper;
    }

    @GET
    @Path(value="category/{id}/categories")
    public CategoriesWrapper findSubCategories(@Context HttpServletRequest request, @PathParam(value="id") Long id, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="active") @DefaultValue(value="true") boolean active) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
            List categories = active ? this.catalogService.findActiveSubCategoriesByCategory(category, limit, offset) : this.catalogService.findAllSubCategories(category, limit, offset);
            wrapper.wrap(categories, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="category/{id}/activeSubcategories")
    public CategoriesWrapper findActiveSubCategories(@Context HttpServletRequest request, @PathParam(value="id") Long id, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            List categories = this.catalogService.findActiveSubCategoriesByCategory(category, limit, offset);
            CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
            wrapper.wrap(categories, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="category/{id}")
    public CategoryWrapper findCategoryById(@Context HttpServletRequest request, @PathParam(value="id") Long id, @QueryParam(value="productLimit") @DefaultValue(value="20") int productLimit, @QueryParam(value="productOffset") @DefaultValue(value="0") int productOffset, @QueryParam(value="subcategoryLimit") @DefaultValue(value="20") int subcategoryLimit, @QueryParam(value="subcategoryOffset") @DefaultValue(value="0") int subcategoryOffset, @QueryParam(value="subcategoryDepth") @DefaultValue(value="1") int subcategoryDepth) {
        Category cat = this.catalogService.findCategoryById(id);
        if (cat != null) {
            request.setAttribute("productLimit", (Object)productLimit);
            request.setAttribute("productOffset", (Object)productOffset);
            request.setAttribute("subcategoryLimit", (Object)subcategoryLimit);
            request.setAttribute("subcategoryOffset", (Object)subcategoryOffset);
            request.setAttribute("subcategoryDepth", (Object)subcategoryDepth);
            CategoryWrapper wrapper = (CategoryWrapper)this.context.getBean(CategoryWrapper.class.getName());
            wrapper.wrap(cat, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="category/{id}/product-attributes")
    public List<CategoryAttributeWrapper> findCategoryAttributesForCategory(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            ArrayList<CategoryAttributeWrapper> out = new ArrayList<CategoryAttributeWrapper>();
            if (category.getCategoryAttributes() != null) {
                for (CategoryAttribute attribute : category.getCategoryAttributes()) {
                    CategoryAttributeWrapper wrapper = (CategoryAttributeWrapper)this.context.getBean(CategoryAttributeWrapper.class.getName());
                    wrapper.wrap(attribute, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="category/{id}/products")
    public List<ProductWrapper> findProductsForCategory(@Context HttpServletRequest request, @PathParam(value="id") Long id, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset, @QueryParam(value="activeOnly") @DefaultValue(value="true") boolean activeOnly) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            ArrayList<ProductWrapper> out = new ArrayList<ProductWrapper>();
            List products = activeOnly ? this.catalogService.findActiveProductsByCategory(category, new Date(), limit, offset) : this.catalogService.findProductsForCategory(category, limit, offset);
            if (products != null) {
                for (Product product : products) {
                    ProductWrapper wrapper = product instanceof ProductBundle ? (ProductWrapper)this.context.getBean(ProductBundleWrapper.class.getName()) : (ProductWrapper)this.context.getBean(ProductWrapper.class.getName());
                    wrapper.wrap(product, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="product/{id}/related-products/upsale")
    public List<RelatedProductWrapper> findUpSaleProductsByProduct(@Context HttpServletRequest request, @PathParam(value="id") Long id, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<RelatedProductWrapper> out = new ArrayList<RelatedProductWrapper>();
            List relatedProds = product.getUpSaleProducts();
            if (relatedProds != null) {
                for (RelatedProduct prod : relatedProds) {
                    RelatedProductWrapper wrapper = (RelatedProductWrapper)this.context.getBean(RelatedProductWrapper.class.getName());
                    wrapper.wrap(prod, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="product/{id}/related-products/crosssale")
    public List<RelatedProductWrapper> findCrossSaleProductsByProduct(@Context HttpServletRequest request, @PathParam(value="id") Long id, @QueryParam(value="limit") @DefaultValue(value="20") int limit, @QueryParam(value="offset") @DefaultValue(value="0") int offset) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<RelatedProductWrapper> out = new ArrayList<RelatedProductWrapper>();
            List xSellProds = product.getCrossSaleProducts();
            if (xSellProds != null) {
                for (RelatedProduct prod : xSellProds) {
                    RelatedProductWrapper wrapper = (RelatedProductWrapper)this.context.getBean(RelatedProductWrapper.class.getName());
                    wrapper.wrap(prod, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="product/{id}/product-attributes")
    public List<ProductAttributeWrapper> findProductAttributesForProduct(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<ProductAttributeWrapper> out = new ArrayList<ProductAttributeWrapper>();
            if (product.getProductAttributes() != null) {
                for (ProductAttribute attribute : product.getProductAttributes()) {
                    ProductAttributeWrapper wrapper = (ProductAttributeWrapper)this.context.getBean(ProductAttributeWrapper.class.getName());
                    wrapper.wrap(attribute, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="sku/{id}/sku-attributes")
    public List<SkuAttributeWrapper> findSkuAttributesForSku(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Sku sku = this.catalogService.findSkuById(id);
        if (sku != null) {
            ArrayList<SkuAttributeWrapper> out = new ArrayList<SkuAttributeWrapper>();
            if (sku.getSkuAttributes() != null) {
                for (SkuAttribute attribute : sku.getSkuAttributes()) {
                    SkuAttributeWrapper wrapper = (SkuAttributeWrapper)this.context.getBean(SkuAttributeWrapper.class.getName());
                    wrapper.wrap(attribute, request);
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="sku/{id}/media")
    public List<MediaWrapper> findMediaForSku(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Sku sku = this.catalogService.findSkuById(id);
        if (sku != null) {
            ArrayList<MediaWrapper> medias = new ArrayList<MediaWrapper>();
            if (sku.getSkuMedia() != null && !sku.getSkuMedia().isEmpty()) {
                for (Media media : sku.getSkuMedia().values()) {
                    MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                    wrapper.wrap(media, request);
                    if (wrapper.isAllowOverrideUrl()) {
                        wrapper.setUrl(this.getStaticAssetService().convertAssetPath(media.getUrl(), request.getContextPath(), request.isSecure()));
                    }
                    medias.add(wrapper);
                }
            }
            return medias;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="sku/{id}")
    public SkuWrapper findSkuById(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Sku sku = this.catalogService.findSkuById(id);
        if (sku != null) {
            SkuWrapper wrapper = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
            wrapper.wrap(sku, request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="product/{id}/media")
    public List<MediaWrapper> findMediaForProduct(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            ArrayList<MediaWrapper> out = new ArrayList<MediaWrapper>();
            Map media = product.getMedia();
            if (media != null) {
                for (Media med : media.values()) {
                    MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                    wrapper.wrap(med, request);
                    if (wrapper.isAllowOverrideUrl()) {
                        wrapper.setUrl(this.getStaticAssetService().convertAssetPath(med.getUrl(), request.getContextPath(), request.isSecure()));
                    }
                    out.add(wrapper);
                }
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="category/{id}/media")
    public List<MediaWrapper> findMediaForCategory(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Category category = this.catalogService.findCategoryById(id);
        if (category != null) {
            ArrayList<MediaWrapper> out = new ArrayList<MediaWrapper>();
            Map media = category.getCategoryMedia();
            for (Media med : media.values()) {
                MediaWrapper wrapper = (MediaWrapper)this.context.getBean(MediaWrapper.class.getName());
                wrapper.wrap(med, request);
                out.add(wrapper);
            }
            return out;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @GET
    @Path(value="product/{id}/categories")
    public CategoriesWrapper findParentCategoriesForProduct(@Context HttpServletRequest request, @PathParam(value="id") Long id) {
        Product product = this.catalogService.findProductById(id);
        if (product != null) {
            CategoriesWrapper wrapper = (CategoriesWrapper)this.context.getBean(CategoriesWrapper.class.getName());
            wrapper.wrap(product.getAllParentCategories(), request);
            return wrapper;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    private StaticAssetService getStaticAssetService() {
        if (this.staticAssetService == null) {
            this.staticAssetService = (StaticAssetService)this.context.getBean("blStaticAssetService");
        }
        return this.staticAssetService;
    }
}

