/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.checkout;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.ui.Model;

public class BroadleafOrderConfirmationController
extends BroadleafAbstractController {
    @Resource(name="blOrderService")
    protected OrderService orderService;
    protected static String orderConfirmationView = "checkout/confirmation";

    public String displayOrderConfirmationByOrderNumber(String orderNumber, Model model, HttpServletRequest request, HttpServletResponse response) {
        Order order;
        Customer customer = CustomerState.getCustomer();
        if (customer != null && (order = this.orderService.findOrderByOrderNumber(orderNumber)) != null && customer.equals(order.getCustomer())) {
            model.addAttribute("order", (Object)order);
            return this.getOrderConfirmationView();
        }
        return null;
    }

    public String displayOrderConfirmationByOrderId(Long orderId, Model model, HttpServletRequest request, HttpServletResponse response) {
        Order order;
        Customer customer = CustomerState.getCustomer();
        if (customer != null && (order = this.orderService.findOrderById(orderId)) != null && customer.equals(order.getCustomer())) {
            model.addAttribute("order", (Object)order);
            return this.getOrderConfirmationView();
        }
        return null;
    }

    public String getOrderConfirmationView() {
        return orderConfirmationView;
    }
}

