/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.account;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.common.exception.ServiceException;
import org.broadleafcommerce.common.web.controller.BroadleafAbstractController;
import org.broadleafcommerce.core.web.controller.account.CustomerAddressForm;
import org.broadleafcommerce.core.web.controller.account.validator.CustomerAddressValidator;
import org.broadleafcommerce.profile.core.domain.Address;
import org.broadleafcommerce.profile.core.domain.Country;
import org.broadleafcommerce.profile.core.domain.CustomerAddress;
import org.broadleafcommerce.profile.core.domain.State;
import org.broadleafcommerce.profile.core.service.AddressService;
import org.broadleafcommerce.profile.core.service.CountryService;
import org.broadleafcommerce.profile.core.service.CustomerAddressService;
import org.broadleafcommerce.profile.core.service.StateService;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

public class BroadleafManageCustomerAddressesController
extends BroadleafAbstractController {
    @Resource(name="blCustomerAddressService")
    private CustomerAddressService customerAddressService;
    @Resource(name="blAddressService")
    private AddressService addressService;
    @Resource(name="blCountryService")
    private CountryService countryService;
    @Resource(name="blCustomerAddressValidator")
    private CustomerAddressValidator customerAddressValidator;
    @Resource(name="blStateService")
    private StateService stateService;
    protected String addressUpdatedMessage = "Address successfully updated";
    protected String addressAddedMessage = "Address successfully added";
    protected String addressRemovedMessage = "Address successfully removed";
    protected String addressRemovedErrorMessage = "Address could not be removed as it is in use";
    protected static String customerAddressesView = "account/manageCustomerAddresses";
    protected static String customerAddressesRedirect = "redirect:/account/addresses";

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws Exception {
        binder.registerCustomEditor(State.class, "address.state", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                State state = BroadleafManageCustomerAddressesController.this.stateService.findStateByAbbreviation(text);
                this.setValue(state);
            }
        });
        binder.registerCustomEditor(Country.class, "address.country", (PropertyEditor)new PropertyEditorSupport(){

            @Override
            public void setAsText(String text) {
                Country country = BroadleafManageCustomerAddressesController.this.countryService.findCountryByAbbreviation(text);
                this.setValue(country);
            }
        });
    }

    protected List<State> populateStates() {
        return this.stateService.findStates();
    }

    protected List<Country> populateCountries() {
        return this.countryService.findCountries();
    }

    protected List<CustomerAddress> populateCustomerAddresses() {
        return this.customerAddressService.readActiveCustomerAddressesByCustomerId(CustomerState.getCustomer().getId());
    }

    public String viewCustomerAddresses(HttpServletRequest request, Model model) {
        model.addAttribute("customerAddressForm", (Object)new CustomerAddressForm());
        return BroadleafManageCustomerAddressesController.getCustomerAddressesView();
    }

    public String viewCustomerAddress(HttpServletRequest request, Model model, Long customerAddressId) {
        CustomerAddress customerAddress = this.customerAddressService.readCustomerAddressById(customerAddressId);
        if (customerAddress == null) {
            throw new IllegalArgumentException("Customer Address not found with the specified customerAddressId");
        }
        CustomerAddressForm form = new CustomerAddressForm();
        form.setAddress(customerAddress.getAddress());
        form.setAddressName(customerAddress.getAddressName());
        form.setCustomerAddressId(customerAddress.getId());
        model.addAttribute("customerAddressForm", (Object)form);
        return BroadleafManageCustomerAddressesController.getCustomerAddressesView();
    }

    public String addCustomerAddress(HttpServletRequest request, Model model, CustomerAddressForm form, BindingResult result, RedirectAttributes redirectAttributes) throws ServiceException {
        this.customerAddressValidator.validate(form, (Errors)result);
        if (result.hasErrors()) {
            return BroadleafManageCustomerAddressesController.getCustomerAddressesView();
        }
        Address address = this.addressService.saveAddress(form.getAddress());
        CustomerAddress customerAddress = this.customerAddressService.create();
        customerAddress.setAddress(address);
        customerAddress.setAddressName(form.getAddressName());
        customerAddress.setCustomer(CustomerState.getCustomer());
        customerAddress = this.customerAddressService.saveCustomerAddress(customerAddress);
        if (form.getAddress().isDefault()) {
            this.customerAddressService.makeCustomerAddressDefault(customerAddress.getId(), customerAddress.getCustomer().getId());
        }
        if (!this.isAjaxRequest(request)) {
            List addresses = this.customerAddressService.readActiveCustomerAddressesByCustomerId(CustomerState.getCustomer().getId());
            model.addAttribute("addresses", (Object)addresses);
        }
        redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAddressAddedMessage());
        return BroadleafManageCustomerAddressesController.getCustomerAddressesRedirect();
    }

    public String updateCustomerAddress(HttpServletRequest request, Model model, Long customerAddressId, CustomerAddressForm form, BindingResult result, RedirectAttributes redirectAttributes) throws ServiceException {
        this.customerAddressValidator.validate(form, (Errors)result);
        if (result.hasErrors()) {
            return BroadleafManageCustomerAddressesController.getCustomerAddressesView();
        }
        CustomerAddress customerAddress = this.customerAddressService.readCustomerAddressById(customerAddressId);
        if (customerAddress == null) {
            throw new IllegalArgumentException("Customer Address not found with the specified customerAddressId");
        }
        customerAddress.setAddress(form.getAddress());
        customerAddress.setAddressName(form.getAddressName());
        customerAddress = this.customerAddressService.saveCustomerAddress(customerAddress);
        if (form.getAddress().isDefault()) {
            this.customerAddressService.makeCustomerAddressDefault(customerAddress.getId(), customerAddress.getCustomer().getId());
        }
        redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAddressUpdatedMessage());
        return BroadleafManageCustomerAddressesController.getCustomerAddressesRedirect();
    }

    public String removeCustomerAddress(HttpServletRequest request, Model model, Long customerAddressId, RedirectAttributes redirectAttributes) {
        try {
            this.customerAddressService.deleteCustomerAddressById(customerAddressId);
            redirectAttributes.addFlashAttribute("successMessage", (Object)this.getAddressRemovedMessage());
        }
        catch (DataIntegrityViolationException e) {
            redirectAttributes.addFlashAttribute("errorMessage", (Object)this.getAddressRemovedErrorMessage());
        }
        return BroadleafManageCustomerAddressesController.getCustomerAddressesRedirect();
    }

    public static String getCustomerAddressesView() {
        return customerAddressesView;
    }

    public static void setCustomerAddressesView(String customerAddressesView) {
        BroadleafManageCustomerAddressesController.customerAddressesView = customerAddressesView;
    }

    public static String getCustomerAddressesRedirect() {
        return customerAddressesRedirect;
    }

    public static void setCustomerAddressesRedirect(String customerAddressesRedirect) {
        BroadleafManageCustomerAddressesController.customerAddressesRedirect = customerAddressesRedirect;
    }

    public String getAddressUpdatedMessage() {
        return this.addressUpdatedMessage;
    }

    public String getAddressAddedMessage() {
        return this.addressAddedMessage;
    }

    public String getAddressRemovedMessage() {
        return this.addressRemovedMessage;
    }

    public String getAddressRemovedErrorMessage() {
        return this.addressRemovedErrorMessage;
    }
}

