/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.endpoint.checkout;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.broadleafcommerce.core.checkout.service.CheckoutService;
import org.broadleafcommerce.core.checkout.service.exception.CheckoutException;
import org.broadleafcommerce.core.checkout.service.workflow.CheckoutResponse;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.domain.PaymentResponseItem;
import org.broadleafcommerce.core.payment.domain.Referenced;
import org.broadleafcommerce.core.payment.service.CompositePaymentService;
import org.broadleafcommerce.core.payment.service.exception.PaymentException;
import org.broadleafcommerce.core.payment.service.workflow.CompositePaymentResponse;
import org.broadleafcommerce.core.pricing.service.exception.PricingException;
import org.broadleafcommerce.core.web.api.wrapper.OrderWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentReferenceMapWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentResponseItemWrapper;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component(value="blRestCheckoutEndpoint")
@Scope(value="singleton")
@Path(value="/cart/checkout/")
@Produces(value={"application/json", "application/xml"})
@Consumes(value={"application/json", "application/xml"})
public class CheckoutEndpoint
implements ApplicationContextAware {
    @Resource(name="blCheckoutService")
    protected CheckoutService checkoutService;
    @Resource(name="blCompositePaymentService")
    protected CompositePaymentService compositePaymentService;
    @Resource(name="blOrderService")
    protected OrderService orderService;
    protected ApplicationContext context;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @POST
    @Path(value="payment/response")
    public PaymentResponseItemWrapper executePayment(@Context HttpServletRequest request, PaymentReferenceMapWrapper mapWrapper) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
                    PaymentInfo paymentInfo = mapWrapper.getPaymentInfoWrapper().unwrap(request, this.context);
                    Referenced referenced = mapWrapper.getReferencedWrapper().unwrap(request, this.context);
                    payments.put(paymentInfo, referenced);
                    CompositePaymentResponse compositePaymentResponse = this.compositePaymentService.executePayment(cart, payments);
                    PaymentResponseItem responseItem = (PaymentResponseItem)compositePaymentResponse.getPaymentResponse().getResponseItems().get(paymentInfo);
                    PaymentResponseItemWrapper paymentResponseItemWrapper = (PaymentResponseItemWrapper)this.context.getBean(PaymentResponseItemWrapper.class);
                    paymentResponseItemWrapper.wrap(responseItem, request);
                    return paymentResponseItemWrapper;
                }
                catch (PaymentException e) {
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }

    @POST
    public OrderWrapper performCheckout(@Context HttpServletRequest request, List<PaymentReferenceMapWrapper> mapWrappers) {
        Customer customer = CustomerState.getCustomer((HttpServletRequest)request);
        if (customer != null) {
            Order cart = this.orderService.findCartForCustomer(customer);
            if (cart != null) {
                try {
                    if (mapWrappers != null && !mapWrappers.isEmpty()) {
                        HashMap<PaymentInfo, Referenced> payments = new HashMap<PaymentInfo, Referenced>();
                        ArrayList<PaymentInfo> paymentInfos = new ArrayList<PaymentInfo>();
                        for (PaymentReferenceMapWrapper mapWrapper : mapWrappers) {
                            PaymentInfo paymentInfo = mapWrapper.getPaymentInfoWrapper().unwrap(request, this.context);
                            Referenced referenced = mapWrapper.getReferencedWrapper().unwrap(request, this.context);
                            payments.put(paymentInfo, referenced);
                            paymentInfos.add(paymentInfo);
                        }
                        cart.setPaymentInfos(paymentInfos);
                        cart.setStatus(OrderStatus.SUBMITTED);
                        cart.setSubmitDate(Calendar.getInstance().getTime());
                        CheckoutResponse response = this.checkoutService.performCheckout(cart, payments);
                        Order order = response.getOrder();
                        OrderWrapper wrapper = (OrderWrapper)this.context.getBean(OrderWrapper.class.getName());
                        wrapper.wrap(order, request);
                        return wrapper;
                    }
                }
                catch (CheckoutException e) {
                    cart.setStatus(OrderStatus.IN_PROCESS);
                    try {
                        this.orderService.save(cart, Boolean.valueOf(false));
                    }
                    catch (PricingException e1) {
                        throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                    }
                    throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
                }
            }
            throw new WebApplicationException(Response.Status.NOT_FOUND);
        }
        throw new WebApplicationException(Response.Status.BAD_REQUEST);
    }
}

