/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.FulfillmentGroupItem;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.service.OrderService;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupItemRequest;
import org.broadleafcommerce.core.order.service.call.FulfillmentGroupRequest;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.AddressWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PhoneWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="fulfillmentGroup")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FulfillmentGroupWrapper
extends BaseWrapper
implements APIWrapper<FulfillmentGroup>,
APIUnwrapper<FulfillmentGroupRequest> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected Long orderId;
    @XmlElement
    protected Money total;
    @XmlElement
    protected AddressWrapper address;
    @XmlElement
    protected PhoneWrapper phone;
    @XmlElement(name="fulfillmentGroupItem")
    @XmlElementWrapper(name="fulfillmentGroupItems")
    protected List<FulfillmentGroupItemWrapper> fulfillmentGroupItems;

    @Override
    public void wrap(FulfillmentGroup model, HttpServletRequest request) {
        List fgs;
        this.id = model.getId();
        this.total = model.getTotal();
        if (model.getOrder() != null) {
            this.orderId = model.getOrder().getId();
        }
        if (model.getAddress() != null) {
            AddressWrapper addressWrapper = (AddressWrapper)this.context.getBean(AddressWrapper.class.getName());
            addressWrapper.wrap(model.getAddress(), request);
            this.address = addressWrapper;
        }
        if (model.getPhone() != null) {
            PhoneWrapper phoneWrapper = (PhoneWrapper)this.context.getBean(PhoneWrapper.class.getName());
            phoneWrapper.wrap(model.getPhone(), request);
            this.phone = phoneWrapper;
        }
        if ((fgs = model.getFulfillmentGroupItems()) != null && !fgs.isEmpty()) {
            ArrayList<FulfillmentGroupItemWrapper> fulfillmentGroupItemWrappers = new ArrayList<FulfillmentGroupItemWrapper>();
            for (FulfillmentGroupItem fgi : fgs) {
                FulfillmentGroupItemWrapper fulfillmentGroupItemWrapper = (FulfillmentGroupItemWrapper)this.context.getBean(FulfillmentGroupItemWrapper.class.getName());
                fulfillmentGroupItemWrapper.wrap(fgi, request);
                fulfillmentGroupItemWrappers.add(fulfillmentGroupItemWrapper);
            }
            this.fulfillmentGroupItems = fulfillmentGroupItemWrappers;
        }
    }

    @Override
    public FulfillmentGroupRequest unwrap(HttpServletRequest request, ApplicationContext appContext) {
        FulfillmentGroupRequest fulfillmentGroupRequest = new FulfillmentGroupRequest();
        ArrayList<FulfillmentGroupItemRequest> fulfillmentGroupItemRequests = new ArrayList<FulfillmentGroupItemRequest>();
        for (FulfillmentGroupItemWrapper wrapper : this.fulfillmentGroupItems) {
            fulfillmentGroupItemRequests.add(wrapper.unwrap(request, appContext));
        }
        fulfillmentGroupRequest.setFulfillmentGroupItemRequests(fulfillmentGroupItemRequests);
        OrderService orderService = (OrderService)appContext.getBean("blCartService");
        Order order = orderService.findOrderById(this.orderId);
        if (order != null) {
            fulfillmentGroupRequest.setOrder(order);
        }
        if (this.address != null) {
            fulfillmentGroupRequest.setAddress(this.address.unwrap(request, appContext));
        }
        if (this.phone != null) {
            fulfillmentGroupRequest.setPhone(this.phone.unwrap(request, appContext));
        }
        return fulfillmentGroupRequest;
    }
}

