/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.common.web.BroadleafRequestContext;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.processor.attr.AbstractAttributeModifierAttrProcessor;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class UrlRewriteProcessor
extends AbstractAttributeModifierAttrProcessor {
    public UrlRewriteProcessor() {
        super("src");
    }

    public int getPrecedence() {
        return 1000;
    }

    protected boolean isRequestSecure(HttpServletRequest request) {
        return "HTTPS".equalsIgnoreCase(request.getScheme()) || request.isSecure();
    }

    protected Map<String, String> getModifiedAttributeValues(Arguments arguments, Element element, String attributeName) {
        HashMap<String, String> attrs = new HashMap<String, String>();
        HttpServletRequest request = BroadleafRequestContext.getBroadleafRequestContext().getRequest();
        StaticAssetService staticAssetService = ProcessorUtils.getStaticAssetService(arguments);
        boolean secureRequest = this.isRequestSecure(request);
        String assetPath = (String)StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue(attributeName));
        assetPath = staticAssetService.convertAssetPath(assetPath, request.getContextPath(), secureRequest);
        attrs.put("src", assetPath);
        return attrs;
    }

    protected AbstractAttributeModifierAttrProcessor.ModificationType getModificationType(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return AbstractAttributeModifierAttrProcessor.ModificationType.SUBSTITUTION;
    }

    protected boolean removeAttributeIfEmpty(Arguments arguments, Element element, String attributeName, String newAttributeName) {
        return true;
    }

    protected boolean recomputeProcessorsAfterExecution(Arguments arguments, Element element, String attributeName) {
        return false;
    }
}

