/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.common.money.Money;
import org.broadleafcommerce.core.order.domain.FulfillmentGroup;
import org.broadleafcommerce.core.order.domain.Order;
import org.broadleafcommerce.core.order.domain.OrderItem;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.CustomerWrapper;
import org.broadleafcommerce.core.web.api.wrapper.FulfillmentGroupWrapper;
import org.broadleafcommerce.core.web.api.wrapper.OrderItemWrapper;
import org.broadleafcommerce.core.web.api.wrapper.PaymentInfoWrapper;

@XmlRootElement(name="order")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OrderWrapper
extends BaseWrapper
implements APIWrapper<Order> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String status;
    @XmlElement
    protected Money totalTax;
    @XmlElement
    protected Money totalShipping;
    @XmlElement
    protected Money subTotal;
    @XmlElement
    protected Money total;
    @XmlElement
    protected CustomerWrapper customer;
    @XmlElement(name="orderItem")
    @XmlElementWrapper(name="orderItems")
    protected List<OrderItemWrapper> orderItems;
    @XmlElement(name="fulfillmentGroup")
    @XmlElementWrapper(name="fulfillmentGroups")
    protected List<FulfillmentGroupWrapper> fulfillmentGroups;
    @XmlElement(name="paymentInfo")
    @XmlElementWrapper(name="paymentInfos")
    protected List<PaymentInfoWrapper> paymentInfos;

    @Override
    public void wrap(Order model, HttpServletRequest request) {
        this.id = model.getId();
        this.status = model.getStatus().getType();
        this.totalTax = model.getTotalTax();
        this.totalShipping = model.getTotalShipping();
        this.subTotal = model.getSubTotal();
        this.total = model.getTotal();
        if (model.getOrderItems() != null && !model.getOrderItems().isEmpty()) {
            this.orderItems = new ArrayList<OrderItemWrapper>();
            for (OrderItem orderItem : model.getOrderItems()) {
                OrderItemWrapper orderItemWrapper = (OrderItemWrapper)this.context.getBean(OrderItemWrapper.class.getName());
                orderItemWrapper.wrap(orderItem, request);
                this.orderItems.add(orderItemWrapper);
            }
        }
        if (model.getFulfillmentGroups() != null && !model.getFulfillmentGroups().isEmpty()) {
            this.fulfillmentGroups = new ArrayList<FulfillmentGroupWrapper>();
            for (FulfillmentGroup fulfillmentGroup : model.getFulfillmentGroups()) {
                FulfillmentGroupWrapper fulfillmentGroupWrapper = (FulfillmentGroupWrapper)this.context.getBean(FulfillmentGroupWrapper.class.getName());
                fulfillmentGroupWrapper.wrap(fulfillmentGroup, request);
                this.fulfillmentGroups.add(fulfillmentGroupWrapper);
            }
        }
        if (model.getPaymentInfos() != null && !model.getPaymentInfos().isEmpty()) {
            this.paymentInfos = new ArrayList<PaymentInfoWrapper>();
            for (PaymentInfo paymentInfo : model.getPaymentInfos()) {
                PaymentInfoWrapper paymentInfoWrapper = (PaymentInfoWrapper)this.context.getBean(PaymentInfoWrapper.class.getName());
                paymentInfoWrapper.wrap(paymentInfo, request);
                this.paymentInfos.add(paymentInfoWrapper);
            }
        }
        CustomerWrapper customerWrapper = (CustomerWrapper)this.context.getBean(CustomerWrapper.class.getName());
        customerWrapper.wrap(model.getCustomer(), request);
        this.customer = customerWrapper;
    }
}

