/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.domain.ReviewDetail;
import org.broadleafcommerce.core.rating.service.RatingService;
import org.broadleafcommerce.core.rating.service.type.RatingType;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.broadleafcommerce.profile.core.domain.Customer;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;
import org.thymeleaf.standard.expression.StandardExpressionProcessor;

public class RatingsProcessor
extends AbstractModelVariableModifierProcessor {
    public RatingsProcessor() {
        super("ratings");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        String itemId;
        RatingService ratingService = ProcessorUtils.getRatingService(arguments);
        RatingSummary ratingSummary = ratingService.readRatingSummary(itemId = String.valueOf(StandardExpressionProcessor.processExpression((Arguments)arguments, (String)element.getAttributeValue("itemId"))), RatingType.PRODUCT);
        if (ratingSummary != null) {
            this.addToModel(arguments, this.getRatingsVar(element), ratingSummary);
        }
        Customer customer = CustomerState.getCustomer();
        ReviewDetail reviewDetail = null;
        if (!customer.isAnonymous()) {
            reviewDetail = ratingService.readReviewByCustomerAndItem(customer, itemId);
        }
        if (reviewDetail != null) {
            this.addToModel(arguments, "currentCustomerReview", reviewDetail);
        }
    }

    private String getRatingsVar(Element element) {
        String ratingsVar = element.getAttributeValue("ratingsVar");
        if (StringUtils.isNotEmpty((String)ratingsVar)) {
            return ratingsVar;
        }
        return "ratingSummary";
    }
}

