/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.processor;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.broadleafcommerce.common.web.dialect.AbstractModelVariableModifierProcessor;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.web.util.ProcessorUtils;
import org.thymeleaf.Arguments;
import org.thymeleaf.dom.Element;

public class CategoriesProcessor
extends AbstractModelVariableModifierProcessor {
    public CategoriesProcessor() {
        super("categories");
    }

    public int getPrecedence() {
        return 10000;
    }

    protected void modifyModelAttributes(Arguments arguments, Element element) {
        CatalogService catalogService = ProcessorUtils.getCatalogService(arguments);
        String resultVar = element.getAttributeValue("resultVar");
        String parentCategory = element.getAttributeValue("parentCategory");
        String unparsedMaxResults = element.getAttributeValue("maxResults");
        List categories = catalogService.findCategoriesByName(parentCategory);
        if (categories != null && categories.size() > 0) {
            List subcategories = ((Category)categories.get(0)).getChildCategories();
            if (subcategories != null && !subcategories.isEmpty() && StringUtils.isNotEmpty((String)unparsedMaxResults)) {
                int maxResults = Integer.parseInt(unparsedMaxResults);
                if (subcategories.size() > maxResults) {
                    subcategories = subcategories.subList(0, maxResults);
                }
            }
            this.addToModel(arguments, resultVar, subcategories);
        }
    }
}

