/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductOption;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.broadleafcommerce.core.web.api.wrapper.ProductOptionWrapper;
import org.broadleafcommerce.core.web.api.wrapper.SkuWrapper;

@XmlRootElement(name="product")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ProductWrapper
extends BaseWrapper
implements APIWrapper<Product> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String name;
    @XmlElement
    protected String description;
    @XmlElement
    protected Date activeStartDate;
    @XmlElement
    protected Date activeEndDate;
    @XmlElement
    protected String manufacturer;
    @XmlElement
    protected String model;
    @XmlElement
    protected String promoMessage;
    @XmlElement
    protected SkuWrapper defaultSku;
    @XmlElement(name="productOption")
    @XmlElementWrapper(name="productOptions")
    protected List<ProductOptionWrapper> productOptions;

    @Override
    public void wrap(Product model, HttpServletRequest request) {
        this.id = model.getId();
        this.name = model.getName();
        this.description = model.getDescription();
        this.activeStartDate = model.getActiveStartDate();
        this.activeEndDate = model.getActiveEndDate();
        this.manufacturer = model.getManufacturer();
        this.model = model.getModel();
        this.promoMessage = model.getPromoMessage();
        if (model.getDefaultSku() != null) {
            this.defaultSku = (SkuWrapper)this.context.getBean(SkuWrapper.class.getName());
            this.defaultSku.wrap(model.getDefaultSku(), request);
        }
        if (model.getProductOptions() != null) {
            this.productOptions = new ArrayList<ProductOptionWrapper>();
            List options = model.getProductOptions();
            for (ProductOption option : options) {
                ProductOptionWrapper optionWrapper = (ProductOptionWrapper)this.context.getBean(ProductOptionWrapper.class.getName());
                optionWrapper.wrap(option, request);
                this.productOptions.add(optionWrapper);
            }
        }
    }
}

