/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.api.wrapper;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.broadleafcommerce.core.payment.domain.AmountItem;
import org.broadleafcommerce.core.payment.domain.AmountItemImpl;
import org.broadleafcommerce.core.payment.domain.PaymentInfo;
import org.broadleafcommerce.core.payment.service.PaymentInfoService;
import org.broadleafcommerce.core.web.api.wrapper.APIUnwrapper;
import org.broadleafcommerce.core.web.api.wrapper.APIWrapper;
import org.broadleafcommerce.core.web.api.wrapper.BaseWrapper;
import org.springframework.context.ApplicationContext;

@XmlRootElement(name="amountItem")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AmountItemWrapper
extends BaseWrapper
implements APIWrapper<AmountItem>,
APIUnwrapper<AmountItem> {
    @XmlElement
    protected Long id;
    @XmlElement
    protected String description;
    @XmlElement
    protected Long paymentInfoId;
    @XmlElement
    protected Long quantity;
    @XmlElement
    protected String shortDescription;
    @XmlElement
    protected String systemId;
    @XmlElement
    protected BigDecimal unitPrice;

    @Override
    public void wrap(AmountItem model, HttpServletRequest request) {
        this.id = model.getId();
        this.description = model.getDescription();
        if (model.getPaymentInfo() != null) {
            this.paymentInfoId = model.getPaymentInfo().getId();
        }
        this.quantity = model.getQuantity();
        this.shortDescription = model.getShortDescription();
        this.systemId = model.getSystemId();
        this.unitPrice = model.getUnitPrice();
    }

    @Override
    public AmountItem unwrap(HttpServletRequest request, ApplicationContext context) {
        AmountItemImpl amountItem = new AmountItemImpl();
        amountItem.setId(this.id);
        amountItem.setDescription(this.description);
        PaymentInfoService paymentInfoService = (PaymentInfoService)context.getBean("blPaymentInfoService");
        PaymentInfo paymentInfo = paymentInfoService.readPaymentInfoById(this.paymentInfoId);
        if (paymentInfo != null) {
            amountItem.setPaymentInfo(paymentInfo);
        }
        amountItem.setQuantity(this.quantity);
        amountItem.setShortDescription(this.shortDescription);
        amountItem.setSystemId(this.systemId);
        amountItem.setUnitPrice(this.unitPrice);
        return amountItem;
    }
}

