/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.controller.catalog;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.collections.comparators.NullComparator;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.FeaturedProduct;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.catalog.domain.ProductSku;
import org.broadleafcommerce.core.catalog.service.CatalogService;
import org.broadleafcommerce.core.order.service.CartService;
import org.broadleafcommerce.core.order.service.type.OrderStatus;
import org.broadleafcommerce.core.rating.domain.RatingSummary;
import org.broadleafcommerce.core.rating.service.RatingService;
import org.broadleafcommerce.core.rating.service.type.RatingType;
import org.broadleafcommerce.core.web.catalog.CatalogSort;
import org.broadleafcommerce.core.web.order.model.WishlistRequest;
import org.broadleafcommerce.core.web.search.SearchFilterUtil;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.broadleafcommerce.profile.web.core.CustomerState;
import org.springframework.beans.propertyeditors.CustomNumberEditor;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.util.UrlPathHelper;

@Controller
@RequestMapping(value={"/store"})
public class CatalogController {
    @Resource(name="blCartService")
    protected CartService cartService;
    @Resource(name="blCustomerState")
    protected CustomerState customerState;
    private final UrlPathHelper pathHelper = new UrlPathHelper();
    private CatalogService catalogService;
    private RatingService ratingService;
    private String defaultCategoryView;
    private String defaultProductView;
    private Long rootCategoryId;
    private String rootCategoryName;
    private String categoryTemplatePrefix;

    @RequestMapping(method={RequestMethod.GET})
    public String viewCatalog(ModelMap model, HttpServletRequest request) {
        return this.showCatalog(model, request, null);
    }

    private String showCatalog(ModelMap model, HttpServletRequest request, CatalogSort catalogSort) {
        this.addCategoryToModel(request, model);
        boolean productFound = this.addProductsToModel(request, model, catalogSort);
        String view = this.defaultCategoryView;
        if (productFound) {
            view = this.defaultProductView;
        } else {
            Category currentCategory = (Category)model.get((Object)"currentCategory");
            if (currentCategory.getUrl() != null && !"".equals(currentCategory.getUrl())) {
                return "redirect:" + currentCategory.getUrl();
            }
            view = currentCategory.getDisplayTemplate() != null && !"".equals(currentCategory.getDisplayTemplate()) ? this.categoryTemplatePrefix + currentCategory.getDisplayTemplate() : ("true".equals(request.getParameter("ajax")) ? "catalog/categoryView/mainContentFragment" : this.defaultCategoryView);
        }
        if (catalogSort == null) {
            model.addAttribute("catalogSort", (Object)new CatalogSort());
        }
        List wishlists = this.cartService.findOrdersForCustomer(this.customerState.getCustomer(request), OrderStatus.NAMED);
        model.addAttribute("wishlists", (Object)wishlists);
        return view;
    }

    @RequestMapping(method={RequestMethod.POST})
    public String sortCatalog(ModelMap model, HttpServletRequest request, @ModelAttribute CatalogSort catalogSort) {
        return this.showCatalog(model, request, catalogSort);
    }

    protected void addCategoryToModel(HttpServletRequest request, ModelMap model) {
        Category category;
        Category rootCategory = null;
        if (this.getRootCategoryId() != null) {
            rootCategory = this.catalogService.findCategoryById(this.getRootCategoryId());
        } else if (this.getRootCategoryName() != null) {
            rootCategory = this.catalogService.findCategoryByName(this.getRootCategoryName());
        }
        if (rootCategory == null) {
            throw new IllegalStateException("Catalog Controller configured incorrectly - rootId category not found: " + this.rootCategoryId);
        }
        String url = this.pathHelper.getRequestUri(request).substring(this.pathHelper.getContextPath(request).length());
        String categoryId = request.getParameter("categoryId");
        if (categoryId != null && (category = this.catalogService.findCategoryById(new Long(categoryId))) != null) {
            url = category.getUrl();
        }
        List categoryIdList = (List)this.catalogService.getChildCategoryURLMapByCategoryId(rootCategory.getId()).get(url);
        ArrayList<Category> categoryList = null;
        if (categoryIdList != null) {
            categoryList = new ArrayList<Category>(categoryIdList.size());
            for (Long id : categoryIdList) {
                categoryList.add(this.catalogService.findCategoryById(id));
            }
        }
        this.addCategoryListToModel(categoryList, rootCategory, url, model);
        model.addAttribute("rootCategory", (Object)rootCategory);
    }

    protected int findProductPositionInList(Product product, List<Product> products) {
        for (int i = 0; i < products.size(); ++i) {
            Product currentProduct = products.get(i);
            if (!product.getId().equals(currentProduct.getId())) continue;
            return i + 1;
        }
        return 0;
    }

    protected boolean addCategoryListToModel(List<Category> categoryList, Category rootCategory, String url, ModelMap model) {
        boolean categoryError = false;
        while (categoryList == null) {
            categoryError = true;
            int pos = url.indexOf("/");
            if (pos == -1) {
                categoryList = new ArrayList<Category>(1);
                categoryList.add(rootCategory);
                continue;
            }
            url = url.substring(0, url.lastIndexOf("/"));
            List categoryIdList = (List)this.catalogService.getChildCategoryURLMapByCategoryId(rootCategory.getId()).get(url);
            if (categoryIdList == null) continue;
            categoryList = new ArrayList<Category>(categoryIdList.size());
            for (Long id : categoryIdList) {
                categoryList.add(this.catalogService.findCategoryById(id));
            }
        }
        List siblingCategories = new ArrayList();
        Category currentCategory = categoryList.get(categoryList.size() - 1);
        siblingCategories = currentCategory.getAllChildCategories();
        model.addAttribute("breadcrumbCategories", categoryList);
        model.addAttribute("currentCategory", (Object)categoryList.get(categoryList.size() - 1));
        model.addAttribute("categoryError", (Object)categoryError);
        model.addAttribute("displayCategories", siblingCategories);
        return categoryError;
    }

    protected boolean validateProductAndAddToModel(Product product, ModelMap model) {
        Category currentCategory = (Category)model.get((Object)"currentCategory");
        Category rootCategory = (Category)model.get((Object)"rootCategory");
        int productPosition = 0;
        List productList = this.catalogService.findActiveProductsByCategory(currentCategory, SystemTime.asDate());
        if (productList != null) {
            this.populateProducts(productList, currentCategory);
            model.addAttribute("products", (Object)productList);
        }
        if ((productPosition = this.findProductPositionInList(product, productList)) == 0 && (currentCategory = product.getDefaultCategory()).isActive()) {
            model.put((Object)"currentCategory", (Object)currentCategory);
            productList = this.catalogService.findActiveProductsByCategory(currentCategory, SystemTime.asDate());
            if (productList != null) {
                model.put((Object)"currentProducts", (Object)productList);
            }
            String url = currentCategory.getGeneratedUrl();
            List categoryIdList = (List)this.catalogService.getChildCategoryURLMapByCategoryId(rootCategory.getId()).get(url);
            ArrayList<Category> categoryList = null;
            if (categoryIdList != null) {
                categoryList = new ArrayList<Category>(categoryIdList.size());
                for (Long id : categoryIdList) {
                    categoryList.add(this.catalogService.findCategoryById(id));
                }
            }
            if (categoryList != null && !this.addCategoryListToModel(categoryList, rootCategory, url, model)) {
                productPosition = this.findProductPositionInList(product, productList);
            }
        }
        if (productPosition != 0) {
            model.addAttribute("productError", (Object)false);
            model.addAttribute("currentProduct", (Object)product);
            model.addAttribute("productPosition", (Object)productPosition);
            if (productPosition != 1) {
                model.addAttribute("previousProduct", productList.get(productPosition - 2));
            }
            if (productPosition < productList.size()) {
                model.addAttribute("nextProduct", productList.get(productPosition));
            }
            model.addAttribute("totalProducts", (Object)productList.size());
        } else {
            model.addAttribute("productError", (Object)true);
        }
        WishlistRequest wishlistRequest = new WishlistRequest();
        wishlistRequest.setAddCategoryId(currentCategory.getId());
        wishlistRequest.setAddProductId(product.getId());
        wishlistRequest.setQuantity(1);
        wishlistRequest.setAddSkuId(((ProductSku)product).getSku().getId());
        model.addAttribute("wishlistRequest", (Object)wishlistRequest);
        return productPosition != 0;
    }

    protected boolean addProductsToModel(HttpServletRequest request, ModelMap model, CatalogSort catalogSort) {
        boolean productFound = false;
        String productId = request.getParameter("productId");
        Product product = null;
        try {
            product = this.catalogService.findProductById(new Long(productId));
        }
        catch (Exception e) {
            // empty catch block
        }
        if (product != null && product.isActive()) {
            productFound = this.validateProductAndAddToModel(product, model);
            this.addRatingSummaryToModel(productId, model);
        } else {
            Category currentCategory = (Category)model.get((Object)"currentCategory");
            List productList = this.catalogService.findActiveProductsByCategory(currentCategory, SystemTime.asDate());
            SearchFilterUtil.filterProducts(productList, request.getParameterMap(), new String[]{"manufacturer", "sku.salePrice"});
            if (catalogSort != null && catalogSort.getSort() != null) {
                this.populateProducts(productList, currentCategory);
                model.addAttribute("displayProducts", this.sortProducts(catalogSort, productList));
            } else {
                catalogSort = new CatalogSort();
                catalogSort.setSort("featured");
                this.populateProducts(productList, currentCategory);
                model.addAttribute("displayProducts", this.sortProducts(catalogSort, productList));
            }
        }
        return productFound;
    }

    private void addRatingSummaryToModel(String productId, ModelMap model) {
        RatingSummary ratingSummary = this.ratingService.readRatingSummary(productId, RatingType.PRODUCT);
        model.addAttribute("ratingSummary", (Object)ratingSummary);
    }

    private void populateProducts(List<Product> productList, Category currentCategory) {
        for (FeaturedProduct featuredProduct : currentCategory.getFeaturedProducts()) {
            for (Product product : productList) {
                if (!product.equals(featuredProduct.getProduct())) continue;
                product.setPromoMessage(featuredProduct.getPromotionMessage());
            }
        }
    }

    private List<Product> sortProducts(CatalogSort catalogSort, List<Product> displayProducts) {
        if (catalogSort.getSort().equals("priceL")) {
            Collections.sort(displayProducts, new BeanComparator("sku.salePrice", (Comparator)new NullComparator()));
        } else if (catalogSort.getSort().equals("priceH")) {
            Collections.sort(displayProducts, new ReverseComparator((Comparator)new BeanComparator("sku.salePrice", (Comparator)new NullComparator())));
        } else if (catalogSort.getSort().equals("manufacturerA")) {
            Collections.sort(displayProducts, new BeanComparator("manufacturer", (Comparator)new NullComparator()));
        } else if (catalogSort.getSort().equals("manufacturerZ")) {
            Collections.sort(displayProducts, new ReverseComparator((Comparator)new BeanComparator("manufacturer", (Comparator)new NullComparator())));
        } else if (catalogSort.getSort().equals("featured")) {
            Collections.sort(displayProducts, new ReverseComparator((Comparator)new BeanComparator("promoMessage", (Comparator)new NullComparator())));
        }
        return displayProducts;
    }

    @InitBinder
    public void initBinder(WebDataBinder binder) {
        binder.registerCustomEditor(Long.class, (PropertyEditor)new CustomNumberEditor(Long.class, false));
        binder.registerCustomEditor(Integer.class, (PropertyEditor)new CustomNumberEditor(Integer.class, false));
    }

    public Long getRootCategoryId() {
        return this.rootCategoryId;
    }

    public String getRootCategoryName() {
        return this.rootCategoryName;
    }

    public void setRootCategoryId(Long rootCategoryId) {
        this.rootCategoryId = rootCategoryId;
    }

    public void setRootCategoryName(String rootCategoryName) {
        this.rootCategoryName = rootCategoryName;
    }

    public CatalogService getCatalogService() {
        return this.catalogService;
    }

    public void setCatalogService(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    public RatingService getRatingService() {
        return this.ratingService;
    }

    public void setRatingService(RatingService ratingService) {
        this.ratingService = ratingService;
    }

    public String getDefaultCategoryView() {
        return this.defaultCategoryView;
    }

    public void setDefaultCategoryView(String defaultCategoryView) {
        this.defaultCategoryView = defaultCategoryView;
    }

    public String getDefaultProductView() {
        return this.defaultProductView;
    }

    public void setDefaultProductView(String defaultProductView) {
        this.defaultProductView = defaultProductView;
    }

    public String getCategoryTemplatePrefix() {
        return this.categoryTemplatePrefix;
    }

    public void setCategoryTemplatePrefix(String categoryTemplatePrefix) {
        this.categoryTemplatePrefix = categoryTemplatePrefix;
    }
}

