/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.core.web.catalog.taglib;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.apache.commons.beanutils.BeanToPropertyValueTransformer;
import org.broadleafcommerce.core.catalog.domain.Category;
import org.broadleafcommerce.core.catalog.domain.Product;
import org.broadleafcommerce.core.web.catalog.taglib.SearchFilterTag;
import org.broadleafcommerce.money.Money;

public class SearchFilterItemTag
extends SimpleTagSupport {
    protected String property;
    protected String propertyDisplay;
    protected String displayTitle;
    protected String displayType = "multiSelect";

    public void doTag() throws JspException, IOException {
        JspWriter out = this.getJspContext().getOut();
        out.println("<h3>" + this.getDisplayTitle() + "</h3>");
        if (this.displayType.equals("multiSelect")) {
            this.doMultiSelect(out);
        } else if (this.displayType.equals("sliderRange")) {
            this.doSliderRange(out);
        }
        super.doTag();
    }

    private void doMultiSelect(JspWriter out) throws JspException, IOException {
        List<Product> products = ((SearchFilterTag)this.getParent()).getProducts();
        List<Category> categories = ((SearchFilterTag)this.getParent()).getCategories();
        if (products != null) {
            this.doProductMultiSelect(out, products);
        }
        if (categories != null) {
            this.doCategoryMultiSelect(out, categories);
        }
    }

    private void doCategoryMultiSelect(JspWriter out, List<Category> categories) throws JspException, IOException {
        String propertyCss = this.property.replaceAll("[\\.\\[\\]]", "_");
        out.println("<ul class='searchFilter-" + propertyCss + "'>");
        for (Category category : categories) {
            String catUrl = this.getUrl(category);
            out.println("<li vaue='" + category.getName() + "'>" + catUrl);
        }
        out.println("</ul>");
    }

    private void doProductMultiSelect(JspWriter out, List<Product> products) throws JspException, IOException {
        Object display;
        BeanToPropertyValueTransformer valueTransformer = new BeanToPropertyValueTransformer(this.property, true);
        BeanToPropertyValueTransformer displayTransformer = this.propertyDisplay != null ? new BeanToPropertyValueTransformer(this.propertyDisplay, true) : valueTransformer;
        HashMap<Object, Integer> countMap = new HashMap<Object, Integer>();
        HashMap<Object, Object> valueDisplayMap = new HashMap<Object, Object>();
        for (Product product : products) {
            Object value = valueTransformer.transform((Object)product);
            display = displayTransformer.transform((Object)product);
            valueDisplayMap.put(value, display);
            Integer integer = (Integer)countMap.get(value);
            if (integer == null) {
                countMap.put(value, new Integer(1));
                continue;
            }
            countMap.put(value, new Integer(integer + 1));
        }
        String propertyCss = this.property.replaceAll("[\\.\\[\\]]", "_");
        out.println("<ul class='searchFilter-" + propertyCss + "'>");
        for (Object value : countMap.keySet()) {
            display = valueDisplayMap.get(value);
            out.println("<li value='" + value + "'><input type=\"checkbox\" class=\"searchFilter-" + propertyCss + "Checkbox\" name=\"" + this.property + "\" value=\"" + value + "\"/> " + "<span class='searchFilter-" + propertyCss + "Display'>" + display + "</span>" + " <span class='searchFilter" + propertyCss + "-count'>(" + ((Integer)countMap.get(value)).toString() + ")</span></li>");
        }
        out.println("</ul>");
        out.println("<script> var " + propertyCss + "Checked = 0;\r\n" + "     $('.searchFilter-" + propertyCss + "Checkbox').click(function() {\r\n " + "        var value = $(this).attr('value');\r\n" + "        var checkbox = $(this).find(':checkbox');\r\n" + "        if (" + propertyCss + "Checked == 0) {\r\n" + "            $('.searchFilter-" + propertyCss + " li').each(function(){$(this).addClass('searchFilterDisabledSelect')});\r\n" + "            $(this).removeClass('searchFilterDisabledSelect');\r\n" + "            checkbox.attr('checked',true);\r\n" + "            " + propertyCss + "Checked++;\r\n" + "        } else if (checkbox.attr('checked') == true) {\r\n" + "            $(this).addClass('searchFilterDisabledSelect');\r\n" + "            if (" + propertyCss + "Checked == 1) {\r\n" + "                // unchecking the only checked category, so reactivate all categories\r\n" + "                $('.searchFilter-" + propertyCss + " li').each(function(){$(this).removeClass('searchFilterDisabledSelect')});\r\n" + "            } \r\n" + "            checkbox.attr('checked',false);\r\n" + "            " + propertyCss + "Checked--;\r\n" + "        } else {\r\n" + "            $(this).removeClass('searchFilterDisabledSelect');\r\n" + "            checkbox.attr('checked',true);\r\n" + "            " + propertyCss + "Checked++;\r\n" + "        }\r\n" + "        updateSearchFilterResults();\r\n" + "    } );" + "     $('.searchFilter-" + propertyCss + "Display').click(function() {\r\n " + "        var value = $(this).attr('value');\r\n" + "        var liObj = $(this).parent(); \r\n" + "        var checkbox = liObj.find(':checkbox');\r\n" + "        if (" + propertyCss + "Checked == 0) {\r\n" + "            $('.searchFilter-" + propertyCss + " li').each(function(){liObj.addClass('searchFilterDisabledSelect')});\r\n" + "            liObj.removeClass('searchFilterDisabledSelect');\r\n" + "            checkbox.attr('checked',true);\r\n" + "            " + propertyCss + "Checked++;\r\n" + "        } else if (checkbox.attr('checked') == true) {\r\n" + "            liObj.addClass('searchFilterDisabledSelect');\r\n" + "            if (" + propertyCss + "Checked == 1) {\r\n" + "                // unchecking the only checked category, so reactivate all categories\r\n" + "                $('.searchFilter-" + propertyCss + " li').each(function(){liObj.removeClass('searchFilterDisabledSelect')});\r\n" + "            } \r\n" + "            checkbox.attr('checked',false);\r\n" + "            " + propertyCss + "Checked--;\r\n" + "        } else {\r\n" + "            liObj.removeClass('searchFilterDisabledSelect');\r\n" + "            checkbox.attr('checked',true);\r\n" + "            " + propertyCss + "Checked++;\r\n" + "        }\r\n" + "        updateSearchFilterResults();\r\n" + "    } );" + "</script>");
    }

    private void doSliderRange(JspWriter out) throws JspException, IOException {
        List<Product> products = ((SearchFilterTag)this.getParent()).getProducts();
        Money min = null;
        Money max = null;
        BeanToPropertyValueTransformer valueTransformer = new BeanToPropertyValueTransformer(this.property, true);
        for (Product product : products) {
            Money propertyObject = (Money)valueTransformer.transform((Object)product);
            if (propertyObject == null) {
                min = new Money(0.0);
                max = new Money(0.0);
                continue;
            }
            min = propertyObject.min(min);
            max = propertyObject.max(max);
        }
        String propertyCss = this.property.replaceAll("[.\\[\\]]", "_");
        out.println("<div id='searchFilter-" + propertyCss + "'></div>");
        out.println("Range:");
        out.println("<input type=\"text\" id=\"min-" + propertyCss + "\" name='min-" + this.property + "' value='$" + min.getAmount().toPlainString() + "'/> - ");
        out.println("<input type=\"text\" id=\"max-" + propertyCss + "\" name='max-" + this.property + "' value='$" + max.getAmount().toPlainString() + "'/> <br/>");
        out.println("        <script type=\"text/javascript\">\r\n        $(function() {\r\n            $(\"#searchFilter-" + propertyCss + "\").slider({\r\n" + "                range: true,\r\n" + "                min: " + min.getAmount().toPlainString() + ", max: " + max.getAmount().toPlainString() + "," + "                values: [" + min.getAmount().toPlainString() + "," + max.getAmount().toPlainString() + "]," + "                slide: function(event, ui) {\r\n" + "                    $(\"#min-" + propertyCss + "\").val('$' + ui.values[0] );\r\n" + "                    $(\"#max-" + propertyCss + "\").val('$' + ui.values[1]);\r\n" + "                }\r\n" + "            });\r\n" + "        });\r\n" + "        $('#searchFilter-" + propertyCss + "').bind('slidechange',  updateSearchFilterResults); \r\n" + "        </script>");
    }

    protected String getUrl(Category category) {
        PageContext pageContext = (PageContext)this.getJspContext();
        HttpServletRequest request = (HttpServletRequest)pageContext.getRequest();
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"");
        sb.append(request.getContextPath());
        sb.append("/");
        sb.append(category.getGeneratedUrl());
        sb.append("\">");
        sb.append(category.getName());
        sb.append("</a>");
        return sb.toString();
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public String getDisplayTitle() {
        if (this.displayTitle == null) {
            return this.property;
        }
        return this.displayTitle;
    }

    public void setDisplayTitle(String displayTitle) {
        this.displayTitle = displayTitle;
    }

    public String getPropertyDisplay() {
        return this.propertyDisplay;
    }

    public void setPropertyDisplay(String propertyDisplay) {
        this.propertyDisplay = propertyDisplay;
    }
}

