/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.service.type;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.presentation.BroadleafEnumerationType;

public class StructuredContentRuleType
implements Serializable,
BroadleafEnumerationType {
    private static final long serialVersionUID = 1L;
    private static final Map<String, StructuredContentRuleType> TYPES = new HashMap<String, StructuredContentRuleType>();
    public static final StructuredContentRuleType REQUEST = new StructuredContentRuleType("REQUEST", "Request");
    public static final StructuredContentRuleType TIME = new StructuredContentRuleType("TIME", "Time");
    public static final StructuredContentRuleType PRODUCT = new StructuredContentRuleType("PRODUCT", "Product");
    public static final StructuredContentRuleType CUSTOMER = new StructuredContentRuleType("CUSTOMER", "Customer");
    private String type;
    private String friendlyType;

    public static StructuredContentRuleType getInstance(String type) {
        return TYPES.get(type);
    }

    public StructuredContentRuleType() {
    }

    public StructuredContentRuleType(String type, String friendlyType) {
        this.friendlyType = friendlyType;
        this.setType(type);
    }

    public void setType(String type) {
        this.type = type;
        if (!TYPES.containsKey(type)) {
            TYPES.put(type, this);
        }
    }

    public String getType() {
        return this.type;
    }

    public String getFriendlyType() {
        return this.friendlyType;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredContentRuleType other = (StructuredContentRuleType)obj;
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }
}

