/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.service;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.structure.service.StructuredContentRuleProcessor;
import org.mvel2.CompileException;
import org.mvel2.MVEL;
import org.mvel2.ParserContext;

public abstract class AbstractStructuredContentRuleProcessor
implements StructuredContentRuleProcessor {
    private static final Log LOG = LogFactory.getLog(AbstractStructuredContentRuleProcessor.class);
    private Map expressionCache = Collections.synchronizedMap(new LRUMap(1000));
    private ParserContext parserContext;
    private Map<String, String> contextClassNames = new HashMap<String, String>();

    protected ParserContext getParserContext() {
        if (this.parserContext == null) {
            this.parserContext = new ParserContext();
            this.parserContext.addImport("MVEL", MVEL.class);
        }
        return this.parserContext;
    }

    protected Boolean executeExpression(String expression, Map<String, Object> vars) {
        Serializable exp = (Serializable)this.expressionCache.get(expression);
        vars.put("MVEL", MVEL.class);
        if (exp == null) {
            try {
                exp = MVEL.compileExpression((String)expression, (ParserContext)this.getParserContext());
            }
            catch (CompileException ce) {
                LOG.warn((Object)("Compile exception processing phrase: " + expression), (Throwable)ce);
                return Boolean.FALSE;
            }
            exp = this.expressionCache.put(expression, exp);
        }
        try {
            return (Boolean)MVEL.executeExpression((Object)exp, vars);
        }
        catch (Exception e) {
            LOG.error((Object)e);
            return false;
        }
    }

    public Map<String, String> getContextClassNames() {
        return this.contextClassNames;
    }

    public void setContextClassNames(Map<String, String> contextClassNames) {
        this.contextClassNames = contextClassNames;
    }
}

