/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentImpl;
import org.broadleafcommerce.cms.structure.domain.StructuredContentItemCriteria;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BLC_SC_ITEM_CRITERIA")
@Inheritance(strategy=InheritanceType.JOINED)
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCMSElements")
@AdminPresentationClass(friendlyName="baseStructuredContentItemCriteria")
public class StructuredContentItemCriteriaImpl
implements StructuredContentItemCriteria {
    public static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="SCItemCriteriaId")
    @GenericGenerator(name="SCItemCriteriaId", strategy="org.broadleafcommerce.persistence.IdOverrideTableGenerator", parameters={@Parameter(name="table_name", value="SEQUENCE_GENERATOR"), @Parameter(name="segment_column_name", value="ID_NAME"), @Parameter(name="value_column_name", value="ID_VAL"), @Parameter(name="segment_value", value="StructuredContentItemCriteriaImpl"), @Parameter(name="increment_size", value="50"), @Parameter(name="entity_name", value="org.broadleafcommerce.core.offer.domain.StructuredContentItemCriteriaImpl")})
    @Column(name="SC_ITEM_CRITERIA_ID")
    @AdminPresentation(friendlyName="Item Criteria Id", group="Description", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Long id;
    @Column(name="QUANTITY", nullable=false)
    @AdminPresentation(friendlyName="Quantity", group="Description", visibility=VisibilityEnum.HIDDEN_ALL)
    protected Integer quantity;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="ORDER_ITEM_MATCH_RULE")
    @AdminPresentation(friendlyName="Order Item Match Rule", group="Description", visibility=VisibilityEnum.HIDDEN_ALL)
    protected String orderItemMatchRule;
    @ManyToOne(targetEntity=StructuredContentImpl.class)
    @JoinTable(name="BLC_QUAL_CRIT_SC_XREF", joinColumns={@JoinColumn(name="SC_ITEM_CRITERIA_ID")}, inverseJoinColumns={@JoinColumn(name="SC_ID")})
    protected StructuredContent structuredContent;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Integer getQuantity() {
        return this.quantity;
    }

    @Override
    public void setQuantity(Integer receiveQuantity) {
        this.quantity = receiveQuantity;
    }

    @Override
    public String getOrderItemMatchRule() {
        return this.orderItemMatchRule;
    }

    @Override
    public void setOrderItemMatchRule(String orderItemMatchRule) {
        this.orderItemMatchRule = orderItemMatchRule;
    }

    @Override
    public StructuredContent getStructuredContent() {
        return this.structuredContent;
    }

    @Override
    public void setStructuredContent(StructuredContent structuredContent) {
        this.structuredContent = structuredContent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.orderItemMatchRule == null ? 0 : this.orderItemMatchRule.hashCode());
        result = 31 * result + (this.quantity == null ? 0 : this.quantity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StructuredContentItemCriteriaImpl other = (StructuredContentItemCriteriaImpl)obj;
        if (this.id != null && other.id != null) {
            return this.id.equals(other.id);
        }
        if (this.orderItemMatchRule == null ? other.orderItemMatchRule != null : !this.orderItemMatchRule.equals(other.orderItemMatchRule)) {
            return false;
        }
        return !(this.quantity == null ? other.quantity != null : !this.quantity.equals(other.quantity));
    }

    @Override
    public StructuredContentItemCriteria cloneEntity() {
        StructuredContentItemCriteriaImpl newField = new StructuredContentItemCriteriaImpl();
        newField.quantity = this.quantity;
        newField.orderItemMatchRule = this.orderItemMatchRule;
        return newField;
    }
}

