/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.page.domain;

import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.cms.page.domain.Page;
import org.broadleafcommerce.cms.page.domain.PageField;
import org.broadleafcommerce.cms.page.domain.PageImpl;
import org.broadleafcommerce.openadmin.audit.AdminAuditable;
import org.broadleafcommerce.openadmin.audit.AdminAuditableListener;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PAGE_FLD")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
@EntityListeners(value={AdminAuditableListener.class})
public class PageFieldImpl
implements PageField {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PageFieldId", strategy=GenerationType.TABLE)
    @TableGenerator(name="PageFieldId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="PageFieldImpl", allocationSize=10)
    @Column(name="PAGE_FLD_ID")
    protected Long id;
    @Embedded
    @AdminPresentation(excluded=true)
    protected AdminAuditable auditable = new AdminAuditable();
    @Column(name="FLD_KEY")
    protected String fieldKey;
    @ManyToOne(targetEntity=PageImpl.class)
    @JoinColumn(name="PAGE_ID")
    protected Page page;
    @Column(name="VALUE")
    protected String stringValue;
    @Column(name="LOB_VALUE")
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    protected String lobValue;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getFieldKey() {
        return this.fieldKey;
    }

    @Override
    public void setFieldKey(String fieldKey) {
        this.fieldKey = fieldKey;
    }

    @Override
    public Page getPage() {
        return this.page;
    }

    @Override
    public void setPage(Page page) {
        this.page = page;
    }

    @Override
    public String getValue() {
        if (this.lobValue != null && this.lobValue.length() > 0) {
            return this.lobValue;
        }
        return this.stringValue;
    }

    @Override
    public void setValue(String value) {
        if (value != null) {
            if (value.length() <= 256) {
                this.stringValue = value;
                this.lobValue = null;
            } else {
                this.stringValue = null;
                this.lobValue = value;
            }
        } else {
            this.lobValue = null;
            this.stringValue = null;
        }
    }

    @Override
    public AdminAuditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(AdminAuditable auditable) {
        this.auditable = auditable;
    }

    @Override
    public PageField cloneEntity() {
        PageFieldImpl newPageField = new PageFieldImpl();
        newPageField.fieldKey = this.fieldKey;
        newPageField.page = this.page;
        newPageField.lobValue = this.lobValue;
        newPageField.stringValue = this.stringValue;
        return newPageField;
    }
}

