/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.client.presenter.structure;

import com.smartgwt.client.data.AdvancedCriteria;
import com.smartgwt.client.data.Criteria;
import com.smartgwt.client.data.DSCallback;
import com.smartgwt.client.data.DSRequest;
import com.smartgwt.client.data.DSResponse;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.form.FilterBuilder;
import java.util.HashMap;
import java.util.Map;
import org.broadleafcommerce.cms.admin.client.presenter.structure.FilterType;
import org.broadleafcommerce.cms.admin.client.presenter.structure.StructuredContentPresenter;
import org.broadleafcommerce.cms.admin.client.view.structure.StructuredContentDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.DynamicEntityDataSource;
import org.broadleafcommerce.openadmin.client.translation.IncompatibleMVELTranslationException;
import org.broadleafcommerce.openadmin.client.translation.MVELToAdvancedCriteriaTranslator;
import org.broadleafcommerce.openadmin.client.view.dynamic.ItemBuilderDisplay;

public class StructuredContentPresenterInitializer {
    public static Map<FilterType, String> ATTRIBUTEMAP = new HashMap<FilterType, String>();
    private static final MVELToAdvancedCriteriaTranslator TRANSLATOR;
    protected StructuredContentPresenter presenter;
    protected DynamicEntityDataSource offerItemCriteriaDataSource;
    protected DynamicEntityDataSource orderItemDataSource;

    public StructuredContentPresenterInitializer(StructuredContentPresenter presenter, DynamicEntityDataSource offerItemCriteriaDataSource, DynamicEntityDataSource orderItemDataSource) {
        this.presenter = presenter;
        this.offerItemCriteriaDataSource = offerItemCriteriaDataSource;
        this.orderItemDataSource = orderItemDataSource;
    }

    protected StructuredContentDisplay getDisplay() {
        return this.presenter.getDisplay();
    }

    public void initSection(Record selectedRecord, boolean disabled) {
        this.initFilterBuilder(this.getDisplay().getCustomerFilterBuilder(), selectedRecord.getAttribute(ATTRIBUTEMAP.get((Object)FilterType.CUSTOMER)));
        this.initFilterBuilder(this.getDisplay().getProductFilterBuilder(), selectedRecord.getAttribute(ATTRIBUTEMAP.get((Object)FilterType.PRODUCT)));
        this.initFilterBuilder(this.getDisplay().getRequestFilterBuilder(), selectedRecord.getAttribute(ATTRIBUTEMAP.get((Object)FilterType.REQUEST)));
        this.initFilterBuilder(this.getDisplay().getTimeFilterBuilder(), selectedRecord.getAttribute(ATTRIBUTEMAP.get((Object)FilterType.TIME)));
        this.initItemQualifiers(selectedRecord, disabled);
    }

    public void initFilterBuilder(FilterBuilder filterBuilder, String rule) {
        filterBuilder.clearCriteria();
        if (rule != null) {
            try {
                AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(rule, filterBuilder.getDataSource());
                if (myCriteria != null) {
                    filterBuilder.setCriteria(myCriteria);
                }
            }
            catch (IncompatibleMVELTranslationException e) {
                throw new RuntimeException(BLCMain.getMessageManager().getString("mvelTranslationProblem"), e);
            }
        }
    }

    public void initItemQualifiers(Record selectedRecord, final boolean disabled) {
        Criteria relationshipCriteria = this.offerItemCriteriaDataSource.createRelationshipCriteria(this.offerItemCriteriaDataSource.getPrimaryKeyValue(selectedRecord));
        this.offerItemCriteriaDataSource.fetchData(relationshipCriteria, new DSCallback(){

            public void execute(DSResponse response, Object rawData, DSRequest request) {
                StructuredContentPresenterInitializer.this.getDisplay().removeAllItemBuilders();
                for (Record record : response.getData()) {
                    if (Integer.parseInt(record.getAttribute("quantity")) <= 0) continue;
                    final ItemBuilderDisplay display = StructuredContentPresenterInitializer.this.getDisplay().addItemBuilder((DataSource)StructuredContentPresenterInitializer.this.orderItemDataSource);
                    display.setDirty(Boolean.valueOf(false));
                    if (disabled) {
                        display.disable();
                    }
                    StructuredContentPresenterInitializer.this.presenter.bindItemBuilderEvents(display);
                    display.getItemFilterBuilder().clearCriteria();
                    display.setRecord(record);
                    display.getItemQuantity().setValue(Integer.parseInt(record.getAttribute("quantity")));
                    try {
                        display.getItemFilterBuilder().setVisible(true);
                        display.getRawItemForm().setVisible(false);
                        AdvancedCriteria myCriteria = TRANSLATOR.createAdvancedCriteria(record.getAttribute("orderItemMatchRule"), (DataSource)StructuredContentPresenterInitializer.this.orderItemDataSource);
                        if (myCriteria != null) {
                            display.getItemFilterBuilder().setCriteria(myCriteria);
                        }
                    }
                    catch (IncompatibleMVELTranslationException e) {
                        throw new RuntimeException(BLCMain.getMessageManager().getString("mvelTranslationProblem"), e);
                    }
                    display.getRemoveButton().addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            StructuredContentPresenterInitializer.this.getDisplay().removeItemBuilder(display);
                        }
                    });
                }
            }
        });
    }

    static {
        ATTRIBUTEMAP.put(FilterType.PRODUCT, "productRule");
        ATTRIBUTEMAP.put(FilterType.REQUEST, "requestRule");
        ATTRIBUTEMAP.put(FilterType.CUSTOMER, "customerRule");
        ATTRIBUTEMAP.put(FilterType.TIME, "timeRule");
        TRANSLATOR = new MVELToAdvancedCriteriaTranslator();
    }
}

