/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.page.domain;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import org.broadleafcommerce.cms.field.domain.FieldGroup;
import org.broadleafcommerce.cms.field.domain.FieldGroupImpl;
import org.broadleafcommerce.cms.page.domain.PageTemplate;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.common.locale.domain.LocaleImpl;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.broadleafcommerce.presentation.PopulateToOneFieldsEnum;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@Table(name="BLC_PAGE_TMPLT")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE, friendlyName="basePageTemplate")
public class PageTemplateImpl
implements PageTemplate {
    private static final long serialVersionUID = 1L;
    @Id
    @GeneratedValue(generator="PageTemplateId", strategy=GenerationType.TABLE)
    @TableGenerator(name="PageTemplateId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="PageTemplateImpl", allocationSize=10)
    @Column(name="PAGE_TMPLT_ID")
    @AdminPresentation(friendlyName="Template Id", visibility=VisibilityEnum.HIDDEN_ALL, readOnly=true)
    protected Long id;
    @Column(name="TMPLT_NAME")
    @AdminPresentation(friendlyName="Template Name", prominent=true)
    protected String templateName;
    @Column(name="TMPLT_DESCR")
    protected String templateDescription;
    @Column(name="TMPLT_PATH")
    @AdminPresentation(friendlyName="Template Path", visibility=VisibilityEnum.HIDDEN_ALL, readOnly=true)
    protected String templatePath;
    @ManyToOne(targetEntity=LocaleImpl.class)
    @JoinColumn(name="LOCALE_CODE")
    protected Locale locale;
    @ManyToMany(targetEntity=FieldGroupImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_PGTMPLT_FLDGRP_XREF", joinColumns={@JoinColumn(name="PAGE_TMPLT_ID", referencedColumnName="PAGE_TMPLT_ID")}, inverseJoinColumns={@JoinColumn(name="FLD_GROUP_ID", referencedColumnName="FLD_GROUP_ID")})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCMSElements")
    @OrderColumn(name="GROUP_ORDER")
    @BatchSize(size=20)
    protected List<FieldGroup> fieldGroups;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String getTemplateName() {
        return this.templateName;
    }

    @Override
    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public String getTemplateDescription() {
        return this.templateDescription;
    }

    @Override
    public void setTemplateDescription(String templateDescription) {
        this.templateDescription = templateDescription;
    }

    @Override
    public String getTemplatePath() {
        return this.templatePath;
    }

    @Override
    public void setTemplatePath(String templatePath) {
        this.templatePath = templatePath;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public List<FieldGroup> getFieldGroups() {
        return this.fieldGroups;
    }

    @Override
    public void setFieldGroups(List<FieldGroup> fieldGroups) {
        this.fieldGroups = fieldGroups;
    }
}

