/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.server.handler;

import com.anasoft.os.daofusion.criteria.PersistentEntityCriteria;
import com.anasoft.os.daofusion.cto.client.CriteriaTransferObject;
import com.anasoft.os.daofusion.cto.server.CriteriaTransferObjectCountWrapper;
import eu.medsea.mimeutil.MimeType;
import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.detector.ExtensionMimeDetector;
import eu.medsea.mimeutil.detector.MagicMimeMimeDetector;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.file.domain.ImageStaticAsset;
import org.broadleafcommerce.cms.file.domain.ImageStaticAssetImpl;
import org.broadleafcommerce.cms.file.domain.StaticAsset;
import org.broadleafcommerce.cms.file.domain.StaticAssetImpl;
import org.broadleafcommerce.cms.file.domain.StaticAssetStorage;
import org.broadleafcommerce.cms.file.service.StaticAssetService;
import org.broadleafcommerce.cms.file.service.StaticAssetStorageService;
import org.broadleafcommerce.openadmin.client.dto.ClassMetadata;
import org.broadleafcommerce.openadmin.client.dto.DynamicResultSet;
import org.broadleafcommerce.openadmin.client.dto.Entity;
import org.broadleafcommerce.openadmin.client.dto.FieldMetadata;
import org.broadleafcommerce.openadmin.client.dto.FieldPresentationAttributes;
import org.broadleafcommerce.openadmin.client.dto.ForeignKey;
import org.broadleafcommerce.openadmin.client.dto.MergedPropertyType;
import org.broadleafcommerce.openadmin.client.dto.PersistencePackage;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspective;
import org.broadleafcommerce.openadmin.client.dto.PersistencePerspectiveItemType;
import org.broadleafcommerce.openadmin.client.dto.Property;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.openadmin.client.presentation.SupportedFieldType;
import org.broadleafcommerce.openadmin.client.service.ServiceException;
import org.broadleafcommerce.openadmin.server.cto.BaseCtoConverter;
import org.broadleafcommerce.openadmin.server.dao.DynamicEntityDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.service.SandBoxContext;
import org.broadleafcommerce.openadmin.server.service.artifact.image.ImageArtifactProcessor;
import org.broadleafcommerce.openadmin.server.service.artifact.image.ImageMetadata;
import org.broadleafcommerce.openadmin.server.service.artifact.upload.UploadedFile;
import org.broadleafcommerce.openadmin.server.service.handler.CustomPersistenceHandlerAdapter;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.broadleafcommerce.openadmin.server.service.persistence.module.InspectHelper;
import org.broadleafcommerce.openadmin.server.service.persistence.module.RecordHelper;
import org.hibernate.Criteria;
import org.springframework.web.multipart.MultipartFile;

public class StaticAssetCustomPersistenceHandler
extends CustomPersistenceHandlerAdapter {
    private static final Log LOG = LogFactory.getLog(StaticAssetCustomPersistenceHandler.class);
    private static HashMap<String, FieldMetadata> mergedProperties;
    @Resource(name="blStaticAssetService")
    protected StaticAssetService staticAssetService;
    @Resource(name="blStaticAssetStorageService")
    protected StaticAssetStorageService staticAssetStorageService;
    @Resource(name="blImageArtifactProcessor")
    protected ImageArtifactProcessor imageArtifactProcessor;
    @Resource(name="blSandBoxService")
    protected SandBoxService sandBoxService;
    protected String assetServerUrlPrefix;

    protected SandBox getSandBox() {
        return this.sandBoxService.retrieveSandboxById(SandBoxContext.getSandBoxContext().getSandBoxId());
    }

    public Boolean canHandleInspect(PersistencePackage persistencePackage) {
        return persistencePackage.getCustomCriteria() != null && persistencePackage.getCustomCriteria().length > 0 && "assetListUi".equals(persistencePackage.getCustomCriteria()[0]);
    }

    public Boolean canHandleAdd(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleFetch(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleRemove(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Boolean canHandleUpdate(PersistencePackage persistencePackage) {
        return this.canHandleInspect(persistencePackage);
    }

    public Entity add(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        if (!persistencePackage.getEntity().isMultiPartAvailableOnThread()) {
            throw new ServiceException("Could not detect an uploaded file.");
        }
        MultipartFile upload = (MultipartFile)UploadedFile.getUpload().get("file");
        Entity entity = persistencePackage.getEntity();
        try {
            MimeType mimeType;
            StaticAsset adminInstance;
            try {
                ImageMetadata metadata = this.imageArtifactProcessor.getImageMetadata(upload.getInputStream());
                adminInstance = new ImageStaticAssetImpl();
                ((ImageStaticAsset)adminInstance).setWidth(metadata.getWidth());
                ((ImageStaticAsset)adminInstance).setHeight(metadata.getHeight());
            }
            catch (Exception e) {
                adminInstance = new StaticAssetImpl();
            }
            Map<String, FieldMetadata> entityProperties = this.getMergedProperties();
            adminInstance = (StaticAsset)helper.createPopulatedInstance((Serializable)adminInstance, entity, entityProperties, Boolean.valueOf(false));
            adminInstance.setFileSize(upload.getSize());
            Collection mimeTypes = MimeUtil.getMimeTypes((String)upload.getOriginalFilename());
            if (!mimeTypes.isEmpty()) {
                mimeType = (MimeType)mimeTypes.iterator().next();
                adminInstance.setMimeType(mimeType.toString());
            } else {
                mimeTypes = MimeUtil.getMimeTypes((InputStream)upload.getInputStream());
                if (!mimeTypes.isEmpty()) {
                    mimeType = (MimeType)mimeTypes.iterator().next();
                    adminInstance.setMimeType(mimeType.toString());
                }
            }
            String extension = upload.getOriginalFilename().substring(upload.getOriginalFilename().lastIndexOf(46) + 1, upload.getOriginalFilename().length()).toLowerCase();
            adminInstance.setFileExtension(extension);
            String fullUrl = adminInstance.getFullUrl();
            if (!fullUrl.startsWith("/")) {
                fullUrl = '/' + fullUrl;
            }
            if (fullUrl.lastIndexOf(46) < 0) {
                fullUrl = fullUrl + '.' + extension;
            }
            adminInstance.setFullUrl(fullUrl);
            adminInstance = this.staticAssetService.addStaticAsset(adminInstance, this.getSandBox());
            Entity adminEntity = helper.getRecord(entityProperties, (Serializable)adminInstance, null, null);
            try {
                StaticAssetStorage storage = this.staticAssetStorageService.create();
                storage.setStaticAssetId(adminInstance.getId());
                Blob uploadBlob = this.staticAssetStorageService.createBlob(upload);
                storage.setFileData(uploadBlob);
                this.staticAssetStorageService.save(storage);
            }
            catch (Exception e) {
                this.staticAssetService.deleteStaticAsset(adminInstance, this.getSandBox());
                throw e;
            }
            return this.addImageRecords(adminEntity);
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to perform add for entity: " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to add entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    public void remove(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        Entity entity = persistencePackage.getEntity();
        try {
            Map<String, FieldMetadata> adminProperties = this.getMergedProperties();
            Object primaryKey = helper.getPrimaryKey(entity, adminProperties);
            StaticAsset adminInstance = (StaticAsset)dynamicEntityDao.retrieve(Class.forName(entity.getType()[0]), primaryKey);
            this.staticAssetService.deleteStaticAsset(adminInstance, this.getSandBox());
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to perform delete for entity: " + entity.getType()[0]), (Throwable)e);
            throw new ServiceException("Unable to delete entity for " + entity.getType()[0], (Throwable)e);
        }
    }

    protected Entity addImageRecords(Entity entity) {
        if (entity.getType()[0].equals(ImageStaticAssetImpl.class.getName())) {
            Property fullUrl = entity.findProperty("fullUrl");
            Property property = new Property();
            property.setName("picture");
            property.setValue(this.assetServerUrlPrefix + fullUrl.getValue() + "?filterType=resize&resize-width-amount=20&resize-height-amount=20&resize-high-quality=false&resize-maintain-aspect-ratio=true&resize-reduce-only=true");
            entity.addProperty(property);
            Property property2 = new Property();
            property2.setName("pictureLarge");
            property2.setValue(this.assetServerUrlPrefix + fullUrl.getValue() + "?filterType=resize&resize-width-amount=60&resize-height-amount=60&resize-high-quality=false&resize-maintain-aspect-ratio=true&resize-reduce-only=true");
            entity.addProperty(property2);
        } else {
            Property property = new Property();
            property.setName("picture");
            property.setValue("[ISOMORPHIC]/../admin/images/Mimetype-binary-icon-16.png");
            entity.addProperty(property);
            Property property2 = new Property();
            property2.setName("pictureLarge");
            property2.setValue("[ISOMORPHIC]/../admin/images/Mimetype-binary-icon-64.png");
            entity.addProperty(property2);
        }
        return entity;
    }

    public DynamicResultSet fetch(PersistencePackage persistencePackage, CriteriaTransferObject cto, DynamicEntityDao dynamicEntityDao, RecordHelper helper) throws ServiceException {
        String ceilingEntityFullyQualifiedClassname = persistencePackage.getCeilingEntityFullyQualifiedClassname();
        try {
            Entity[] assetEntities;
            PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
            BaseCtoConverter ctoConverter = helper.getCtoConverter(persistencePerspective, cto, StaticAsset.class.getName(), this.getMergedProperties());
            PersistentEntityCriteria queryCriteria = ctoConverter.convert(cto, StaticAsset.class.getName());
            PersistentEntityCriteria countCriteria = ctoConverter.convert(new CriteriaTransferObjectCountWrapper(cto).wrap(), StaticAsset.class.getName());
            Criteria criteria = dynamicEntityDao.getCriteria(queryCriteria, StaticAsset.class);
            Criteria count = dynamicEntityDao.getCriteria(countCriteria, StaticAsset.class);
            Object sandBox = persistencePackage.getCustomCriteria().length > 1 && "prodOnly".equals(persistencePackage.getCustomCriteria()[1]) ? null : this.getSandBox();
            List<StaticAsset> items = this.staticAssetService.findAssets((SandBox)sandBox, criteria);
            Long totalRecords = this.staticAssetService.countAssets((SandBox)sandBox, count);
            ArrayList<StaticAsset> convertedList = new ArrayList<StaticAsset>(items.size());
            convertedList.addAll(items);
            for (Entity entity : assetEntities = helper.getRecords(this.getMergedProperties(), convertedList)) {
                if (!"true".equals((entity = this.addImageRecords(entity)).findProperty("lockedFlag").getValue())) continue;
                Property property = new Property();
                property.setName("picture");
                property.setValue("[ISOMORPHIC]/../admin/images/lock_page.png");
                entity.addProperty(property);
            }
            return new DynamicResultSet(assetEntities, Integer.valueOf(totalRecords.intValue()));
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to perform fetch for entity: " + ceilingEntityFullyQualifiedClassname), (Throwable)e);
            throw new ServiceException("Unable to perform fetch for entity: " + ceilingEntityFullyQualifiedClassname, (Throwable)e);
        }
    }

    protected synchronized Map<String, FieldMetadata> getMergedProperties() {
        return mergedProperties;
    }

    protected synchronized void createMergedProperties(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, Class<?>[] entityClasses) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException {
        PersistencePerspective persistencePerspective = persistencePackage.getPersistencePerspective();
        HashMap originalProps = (HashMap)dynamicEntityDao.getMergedProperties(StaticAsset.class.getName(), (Class[])entityClasses, (ForeignKey)persistencePerspective.getPersistencePerspectiveItems().get(PersistencePerspectiveItemType.FOREIGNKEY), persistencePerspective.getAdditionalNonPersistentProperties(), persistencePerspective.getAdditionalForeignKeys(), MergedPropertyType.PRIMARY, persistencePerspective.getPopulateToOneFields(), persistencePerspective.getIncludeFields(), persistencePerspective.getExcludeFields(), persistencePerspective.getConfigurationKey(), "");
        mergedProperties = (HashMap)SerializationUtils.clone((Serializable)originalProps);
        FieldMetadata fieldMetadata = new FieldMetadata();
        fieldMetadata.setFieldType(SupportedFieldType.UPLOAD);
        fieldMetadata.setMutable(Boolean.valueOf(true));
        fieldMetadata.setInheritedFromType(StaticAssetImpl.class.getName());
        fieldMetadata.setAvailableToTypes(new String[]{StaticAssetImpl.class.getName(), ImageStaticAssetImpl.class.getName()});
        fieldMetadata.setCollection(Boolean.valueOf(false));
        fieldMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes attributes = new FieldPresentationAttributes();
        fieldMetadata.setPresentationAttributes(attributes);
        attributes.setName("file");
        attributes.setFriendlyName("File");
        attributes.setGroup("Upload");
        attributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        attributes.setProminent(Boolean.valueOf(false));
        attributes.setBroadleafEnumeration("");
        attributes.setReadOnly(Boolean.valueOf(false));
        attributes.setVisibility(VisibilityEnum.HIDDEN_ALL);
        attributes.setRequiredOverride(Boolean.valueOf(true));
        mergedProperties.put("file", fieldMetadata);
        FieldMetadata iconMetadata = new FieldMetadata();
        iconMetadata.setFieldType(SupportedFieldType.ASSET);
        iconMetadata.setMutable(Boolean.valueOf(true));
        iconMetadata.setInheritedFromType(StaticAssetImpl.class.getName());
        iconMetadata.setAvailableToTypes(new String[]{StaticAssetImpl.class.getName(), ImageStaticAssetImpl.class.getName()});
        iconMetadata.setCollection(Boolean.valueOf(false));
        iconMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes iconAttributes = new FieldPresentationAttributes();
        iconMetadata.setPresentationAttributes(iconAttributes);
        iconAttributes.setName("picture");
        iconAttributes.setFriendlyName(" ");
        iconAttributes.setGroup("Asset Details");
        iconAttributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        iconAttributes.setProminent(Boolean.valueOf(true));
        iconAttributes.setBroadleafEnumeration("");
        iconAttributes.setReadOnly(Boolean.valueOf(false));
        iconAttributes.setVisibility(VisibilityEnum.FORM_HIDDEN);
        iconAttributes.setColumnWidth("25");
        iconAttributes.setOrder(Integer.valueOf(0));
        iconAttributes.setRequiredOverride(Boolean.valueOf(false));
        mergedProperties.put("picture", iconMetadata);
        FieldMetadata iconLargeMetadata = new FieldMetadata();
        iconLargeMetadata.setFieldType(SupportedFieldType.ASSET);
        iconLargeMetadata.setMutable(Boolean.valueOf(true));
        iconLargeMetadata.setInheritedFromType(StaticAssetImpl.class.getName());
        iconLargeMetadata.setAvailableToTypes(new String[]{StaticAssetImpl.class.getName(), ImageStaticAssetImpl.class.getName()});
        iconLargeMetadata.setCollection(Boolean.valueOf(false));
        iconLargeMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes iconLargeAttributes = new FieldPresentationAttributes();
        iconLargeMetadata.setPresentationAttributes(iconLargeAttributes);
        iconLargeAttributes.setName("pictureLarge");
        iconLargeAttributes.setFriendlyName("Preview");
        iconLargeAttributes.setGroup("Preview");
        iconLargeAttributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        iconLargeAttributes.setProminent(Boolean.valueOf(false));
        iconLargeAttributes.setBroadleafEnumeration("");
        iconLargeAttributes.setReadOnly(Boolean.valueOf(true));
        iconLargeAttributes.setVisibility(VisibilityEnum.VISIBLE_ALL);
        iconLargeAttributes.setRequiredOverride(Boolean.valueOf(false));
        iconLargeAttributes.setOrder(Integer.valueOf(0));
        iconLargeAttributes.setGroupOrder(Integer.valueOf(0));
        mergedProperties.put("pictureLarge", iconLargeMetadata);
        mergedProperties.put("callbackName", this.createHiddenField("callbackName"));
        mergedProperties.put("operation", this.createHiddenField("operation"));
        mergedProperties.put("sandbox", this.createHiddenField("sandbox"));
        mergedProperties.put("ceilingEntityFullyQualifiedClassname", this.createHiddenField("ceilingEntityFullyQualifiedClassname"));
        mergedProperties.put("parentFolder", this.createHiddenField("parentFolder"));
        mergedProperties.put("idHolder", this.createHiddenField("idHolder"));
        mergedProperties.put("customCriteria", this.createHiddenField("customCriteria"));
        mergedProperties.put("csrfToken", this.createHiddenField("csrfToken"));
    }

    public DynamicResultSet inspect(PersistencePackage persistencePackage, DynamicEntityDao dynamicEntityDao, InspectHelper helper) throws ServiceException {
        try {
            EnumMap<MergedPropertyType, Map<String, FieldMetadata>> allMergedProperties = new EnumMap<MergedPropertyType, Map<String, FieldMetadata>>(MergedPropertyType.class);
            Class[] entityClasses = dynamicEntityDao.getAllPolymorphicEntitiesFromCeiling(StaticAsset.class);
            if (this.getMergedProperties() == null) {
                this.createMergedProperties(persistencePackage, dynamicEntityDao, entityClasses);
            }
            allMergedProperties.put(MergedPropertyType.PRIMARY, this.getMergedProperties());
            ClassMetadata mergedMetadata = helper.getMergedClassMetadata(entityClasses, allMergedProperties);
            return new DynamicResultSet(mergedMetadata);
        }
        catch (Exception e) {
            ServiceException ex = new ServiceException("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname(), (Throwable)e);
            LOG.error((Object)("Unable to retrieve inspection results for " + persistencePackage.getCeilingEntityFullyQualifiedClassname()), (Throwable)ex);
            throw ex;
        }
    }

    protected FieldMetadata createHiddenField(String name) {
        FieldMetadata fieldMetadata = new FieldMetadata();
        fieldMetadata.setFieldType(SupportedFieldType.HIDDEN);
        fieldMetadata.setMutable(Boolean.valueOf(true));
        fieldMetadata.setInheritedFromType(StaticAssetImpl.class.getName());
        fieldMetadata.setAvailableToTypes(new String[]{StaticAssetImpl.class.getName()});
        fieldMetadata.setCollection(Boolean.valueOf(false));
        fieldMetadata.setMergedPropertyType(MergedPropertyType.PRIMARY);
        FieldPresentationAttributes attributes = new FieldPresentationAttributes();
        fieldMetadata.setPresentationAttributes(attributes);
        attributes.setName(name);
        attributes.setFriendlyName(name);
        attributes.setGroup("Upload");
        attributes.setExplicitFieldType(SupportedFieldType.UNKNOWN);
        attributes.setProminent(Boolean.valueOf(false));
        attributes.setBroadleafEnumeration("");
        attributes.setReadOnly(Boolean.valueOf(false));
        attributes.setVisibility(VisibilityEnum.HIDDEN_ALL);
        return fieldMetadata;
    }

    public String getAssetServerUrlPrefix() {
        return this.assetServerUrlPrefix;
    }

    public void setAssetServerUrlPrefix(String assetServerUrlPrefix) {
        this.assetServerUrlPrefix = assetServerUrlPrefix;
    }

    static {
        MimeUtil.registerMimeDetector((String)ExtensionMimeDetector.class.getName());
        MimeUtil.registerMimeDetector((String)MagicMimeMimeDetector.class.getName());
    }
}

