/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.admin.client.presenter.sandbox;

import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.smartgwt.client.data.DataSource;
import com.smartgwt.client.data.Record;
import com.smartgwt.client.widgets.Canvas;
import com.smartgwt.client.widgets.DataBoundComponent;
import com.smartgwt.client.widgets.events.ClickEvent;
import com.smartgwt.client.widgets.events.ClickHandler;
import com.smartgwt.client.widgets.grid.ListGridRecord;
import com.smartgwt.client.widgets.grid.events.DataArrivedEvent;
import com.smartgwt.client.widgets.grid.events.DataArrivedHandler;
import com.smartgwt.client.widgets.grid.events.SelectionChangedHandler;
import com.smartgwt.client.widgets.grid.events.SelectionEvent;
import org.broadleafcommerce.cms.admin.client.datasource.sandbox.SandBoxItemListDataSourceFactory;
import org.broadleafcommerce.cms.admin.client.view.sandbox.CommentCallback;
import org.broadleafcommerce.cms.admin.client.view.sandbox.CommentDialog;
import org.broadleafcommerce.cms.admin.client.view.sandbox.SandBoxDisplay;
import org.broadleafcommerce.openadmin.client.BLCMain;
import org.broadleafcommerce.openadmin.client.datasource.DataSourceFactory;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.CustomCriteriaListGridDataSource;
import org.broadleafcommerce.openadmin.client.datasource.dynamic.PresentationLayerAssociatedDataSource;
import org.broadleafcommerce.openadmin.client.presenter.entity.AbstractEntityPresenter;
import org.broadleafcommerce.openadmin.client.presenter.entity.EntityPresenter;
import org.broadleafcommerce.openadmin.client.reflection.Instantiable;
import org.broadleafcommerce.openadmin.client.security.SecurityManager;
import org.broadleafcommerce.openadmin.client.setup.AsyncCallbackAdapter;
import org.broadleafcommerce.openadmin.client.setup.PresenterSequenceSetupManager;
import org.broadleafcommerce.openadmin.client.setup.PresenterSetupItem;
import org.broadleafcommerce.openadmin.client.view.Display;

public class SandBoxPresenter
extends AbstractEntityPresenter
implements Instantiable {
    private static final CommentDialog COMMENT_DIALOG = new CommentDialog();
    protected SandBoxDisplay display;
    protected ListGridRecord lastSelectedRecord = null;
    protected Boolean loaded = false;
    protected HandlerRegistration selectionChangedHandlerRegistration;
    protected HandlerRegistration revertRejectAllClickHandlerRegistration;
    protected HandlerRegistration revertRejectSelectionClickHandlerRegistration;
    protected HandlerRegistration promoteAllClickHandlerRegistration;
    protected HandlerRegistration promoteSelectionClickHandlerRegistration;
    protected HandlerRegistration refreshClickHandlerRegistration;
    protected HandlerRegistration previewClickHandlerRegistration;
    protected PresenterSequenceSetupManager presenterSequenceSetupManager = new PresenterSequenceSetupManager((EntityPresenter)this);
    protected Boolean disabled = false;

    public void setStartState() {
        this.display.getPromoteAllButton().disable();
        this.display.getPromoteSelectionButton().disable();
        this.display.getRevertRejectAllButton().disable();
        this.display.getRevertRejectSelectionButton().disable();
        this.display.getRefreshButton().enable();
        this.display.getPreviewButton().disable();
    }

    public void enable() {
        this.disabled = false;
        this.display.getPromoteAllButton().enable();
        this.display.getPromoteSelectionButton().disable();
        this.display.getRevertRejectAllButton().enable();
        this.display.getRevertRejectSelectionButton().disable();
        this.display.getPreviewButton().disable();
    }

    public void disable() {
        this.disabled = true;
        this.setStartState();
    }

    protected String getSelectedRecords() {
        ListGridRecord[] records = this.display.getGrid().getSelection();
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < records.length; ++j) {
            String id = this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS").getPrimaryKeyValue((Record)records[j]);
            sb.append(id);
            if (j >= records.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    protected void previewSelection(ListGridRecord[] records) {
        String path = BLCMain.buildStoreFrontBaseUrl();
        if (records == null || records != null && records.length > 1) {
            path = path + "?blSandboxId=" + SecurityManager.USER.getCurrentSandBoxId();
        } else {
            String specificSandboxId = records[0].getAttribute("sandBox.id");
            String type = records[0].getAttribute("sandBoxItemType");
            if (type.equals("PAGE")) {
                path = path + records[0].getAttribute("description");
            }
            path = path + "?blSandboxId=" + specificSandboxId;
        }
        Window.open((String)path, (String)"cmsPreview", null);
    }

    protected void invalidateMyCache() {
        ((CustomCriteriaListGridDataSource)this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "fetch", "", "", "standard"});
        this.setStartState();
        this.display.getGrid().invalidateCache();
    }

    public void bind() {
        this.previewClickHandlerRegistration = this.display.getPreviewButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    ListGridRecord[] records = SandBoxPresenter.this.display.getGrid().getSelection();
                    SandBoxPresenter.this.previewSelection(records);
                }
            }
        });
        this.refreshClickHandlerRegistration = this.display.getRefreshButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    SandBoxPresenter.this.invalidateMyCache();
                }
            }
        });
        this.revertRejectAllClickHandlerRegistration = this.display.getRevertRejectAllButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    if (BLCMain.currentViewKey.equals("userSandBox")) {
                        ((CustomCriteriaListGridDataSource)SandBoxPresenter.this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "revertRejectAll", "", "", "standard"});
                        SandBoxPresenter.this.setStartState();
                        SandBoxPresenter.this.display.getGrid().invalidateCache();
                    } else {
                        COMMENT_DIALOG.launch("Enter a rejection comment", new CommentCallback(){

                            @Override
                            public void comment(String comment) {
                                ((CustomCriteriaListGridDataSource)SandBoxPresenter.this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "revertRejectAll", "", comment, "standard"});
                                SandBoxPresenter.this.setStartState();
                                SandBoxPresenter.this.display.getGrid().invalidateCache();
                            }
                        });
                    }
                }
            }
        });
        this.revertRejectSelectionClickHandlerRegistration = this.display.getRevertRejectSelectionButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    if (BLCMain.currentViewKey.equals("userSandBox")) {
                        ((CustomCriteriaListGridDataSource)SandBoxPresenter.this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "revertRejectSelected", SandBoxPresenter.this.getSelectedRecords(), "", "standard"});
                        SandBoxPresenter.this.setStartState();
                        SandBoxPresenter.this.display.getGrid().invalidateCache();
                    } else {
                        COMMENT_DIALOG.launch("Enter a rejection comment", new CommentCallback(){

                            @Override
                            public void comment(String comment) {
                                ((CustomCriteriaListGridDataSource)SandBoxPresenter.this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "revertRejectSelected", SandBoxPresenter.this.getSelectedRecords(), comment, "standard"});
                                SandBoxPresenter.this.setStartState();
                                SandBoxPresenter.this.display.getGrid().invalidateCache();
                            }
                        });
                    }
                }
            }
        });
        this.selectionChangedHandlerRegistration = this.display.getGrid().addSelectionChangedHandler(new SelectionChangedHandler(){

            public void onSelectionChanged(SelectionEvent event) {
                ListGridRecord selectedRecord = event.getSelectedRecord();
                if (event.getState() && selectedRecord != null && !selectedRecord.equals(SandBoxPresenter.this.lastSelectedRecord)) {
                    SandBoxPresenter.this.display.getRevertRejectSelectionButton().enable();
                    SandBoxPresenter.this.display.getPromoteSelectionButton().enable();
                    SandBoxPresenter.this.display.getPreviewButton().enable();
                }
            }
        });
        this.promoteAllClickHandlerRegistration = this.display.getPromoteAllButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    COMMENT_DIALOG.launch("Enter a promotion comment", new CommentCallback(){

                        @Override
                        public void comment(String comment) {
                            ((CustomCriteriaListGridDataSource)SandBoxPresenter.this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "promoteAll", "", comment, "standard"});
                            SandBoxPresenter.this.setStartState();
                            SandBoxPresenter.this.display.getGrid().invalidateCache();
                            Timer timer = new Timer(){

                                public void run() {
                                    SandBoxPresenter.this.invalidateOtherCache();
                                }
                            };
                            timer.schedule(1000);
                        }
                    });
                }
            }
        });
        this.promoteSelectionClickHandlerRegistration = this.display.getPromoteSelectionButton().addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                if (event.isLeftButtonDown()) {
                    COMMENT_DIALOG.launch("Enter a promotion comment", new CommentCallback(){

                        @Override
                        public void comment(String comment) {
                            ((CustomCriteriaListGridDataSource)SandBoxPresenter.this.getPresenterSequenceSetupManager().getDataSource("sandBoxItemDS")).setCustomCriteria(new String[]{BLCMain.currentViewKey, "promoteSelected", SandBoxPresenter.this.getSelectedRecords(), comment, "standard"});
                            SandBoxPresenter.this.setStartState();
                            SandBoxPresenter.this.display.getGrid().invalidateCache();
                            Timer timer = new Timer(){

                                public void run() {
                                    SandBoxPresenter.this.invalidateOtherCache();
                                }
                            };
                            timer.schedule(1000);
                        }
                    });
                }
            }
        });
        this.display.getGrid().addDataArrivedHandler(new DataArrivedHandler(){

            public void onDataArrived(DataArrivedEvent event) {
                if (event.getEndRow() > event.getStartRow()) {
                    SandBoxPresenter.this.enable();
                }
            }
        });
    }

    public void postSetup(Canvas container) {
        BLCMain.ISNEW = false;
        if (this.containsDisplay(container).booleanValue()) {
            this.display.show();
        } else {
            this.bind();
            container.addChild(this.display.asCanvas());
            this.loaded = true;
        }
        if (BLCMain.MODAL_PROGRESS.isActive().booleanValue()) {
            BLCMain.MODAL_PROGRESS.stopProgress();
        }
        if (BLCMain.SPLASH_PROGRESS.isActive().booleanValue()) {
            BLCMain.SPLASH_PROGRESS.stopProgress();
        }
    }

    public void setup() {
        this.getPresenterSequenceSetupManager().addOrReplaceItem(new PresenterSetupItem("sandBoxItemDS", (DataSourceFactory)new SandBoxItemListDataSourceFactory(), null, new Object[]{BLCMain.currentViewKey, "fetch", "", "", "standard"}, new AsyncCallbackAdapter(){

            public void onSetupSuccess(DataSource dataSource) {
                SandBoxPresenter.this.setupDisplayItems(dataSource, new DataSource[0]);
                ((CustomCriteriaListGridDataSource)dataSource).setupGridFields(new String[]{"auditable.createdBy.name", "description", "sandBoxItemType", "sandboxOperationType", "auditable.dateCreated", "auditable.dateUpdated"});
            }
        }));
    }

    protected Boolean containsDisplay(Canvas container) {
        return container.contains(this.display.asCanvas());
    }

    public SandBoxDisplay getDisplay() {
        return this.display;
    }

    public void setDisplay(Display display) {
        this.display = (SandBoxDisplay)display;
    }

    protected void setupDisplayItems(DataSource entityDataSource, DataSource ... additionalDataSources) {
        this.getDisplay().build(entityDataSource, additionalDataSources);
        ((PresentationLayerAssociatedDataSource)entityDataSource).setAssociatedGrid((DataBoundComponent)this.display.getGrid());
        this.setStartState();
    }

    public HandlerRegistration getSelectionChangedHandlerRegistration() {
        return this.selectionChangedHandlerRegistration;
    }

    public HandlerRegistration getRevertRejectAllClickHandlerRegistration() {
        return this.revertRejectAllClickHandlerRegistration;
    }

    public HandlerRegistration getRevertRejectSelectionClickHandlerRegistration() {
        return this.revertRejectSelectionClickHandlerRegistration;
    }

    public HandlerRegistration getPromoteAllClickHandlerRegistration() {
        return this.promoteAllClickHandlerRegistration;
    }

    public HandlerRegistration getPromoteSelectionClickHandlerRegistration() {
        return this.promoteSelectionClickHandlerRegistration;
    }

    public HandlerRegistration getRefreshClickHandlerRegistration() {
        return this.refreshClickHandlerRegistration;
    }

    public PresenterSequenceSetupManager getPresenterSequenceSetupManager() {
        return this.presenterSequenceSetupManager;
    }

    public Boolean getLoaded() {
        return this.loaded;
    }

    protected void invalidateOtherCache() {
    }
}

