/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.structure.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.beanutils.BeanComparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.structure.dao.StructuredContentDao;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentField;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.cms.structure.service.StructuredContentRuleProcessor;
import org.broadleafcommerce.cms.structure.service.StructuredContentService;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.openadmin.server.dao.SandBoxDao;
import org.broadleafcommerce.openadmin.server.dao.SandBoxItemDao;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItem;
import org.broadleafcommerce.openadmin.server.domain.SandBoxItemType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxOperationType;
import org.broadleafcommerce.openadmin.server.domain.SandBoxType;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.springframework.stereotype.Service;

@Service(value="blStructuredContentService")
public class StructuredContentServiceImpl
implements StructuredContentService {
    private static final Log LOG = LogFactory.getLog(StructuredContentServiceImpl.class);
    @Resource(name="blStructuredContentDao")
    protected StructuredContentDao structuredContentDao;
    @Resource(name="blSandBoxItemDao")
    protected SandBoxItemDao sandBoxItemDao;
    @Resource(name="blSandBoxDao")
    protected SandBoxDao sandBoxDao;
    private List<StructuredContentRuleProcessor> contentRuleProcessors;

    @Override
    public StructuredContent findStructuredContentById(Long contentId) {
        return this.structuredContentDao.findStructuredContentById(contentId);
    }

    @Override
    public StructuredContentType findStructuredContentTypeById(Long id) {
        return this.structuredContentDao.findStructuredContentTypeById(id);
    }

    @Override
    public StructuredContentType findStructuredContentTypeByName(String name) {
        return this.structuredContentDao.findStructuredContentTypeByName(name);
    }

    @Override
    public List<StructuredContentType> retrieveAllStructuredContentTypes() {
        return this.structuredContentDao.retrieveAllStructuredContentTypes();
    }

    @Override
    public Map<String, StructuredContentField> findFieldsByContentId(Long contentId) {
        StructuredContent sc = this.findStructuredContentById(contentId);
        return this.structuredContentDao.readFieldsForStructuredContentItem(sc);
    }

    @Override
    public List<StructuredContent> findContentItems(SandBox sandbox, Criteria c) {
        c.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        if (sandbox == null) {
            c.add(Restrictions.isNull((String)"sandbox"));
            return c.list();
        }
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        Criterion productionSandboxExpression = null;
        if (sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null) {
            productionSandboxExpression = Restrictions.isNull((String)"sandbox");
        } else if (!SandBoxType.PRODUCTION.equals((Object)sandbox.getSandBoxType())) {
            productionSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        }
        if (productionSandboxExpression != null) {
            c.add((Criterion)Restrictions.or((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)productionSandboxExpression), (Criterion)originalSandboxExpression));
        } else {
            c.add((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression));
        }
        List resultList = c.list();
        LinkedHashMap<Long, StructuredContent> returnItems = new LinkedHashMap<Long, StructuredContent>();
        for (StructuredContent content : resultList) {
            returnItems.put(content.getId(), content);
        }
        for (StructuredContent content : resultList) {
            if (content.getOriginalItemId() != null) {
                returnItems.remove(content.getOriginalItemId());
            }
            if (!content.getDeletedFlag().booleanValue()) continue;
            returnItems.remove(content.getId());
        }
        return new ArrayList<StructuredContent>(returnItems.values());
    }

    @Override
    public Long countContentItems(SandBox sandbox, Criteria c) {
        Criterion productionSandboxExpression;
        c.add((Criterion)Restrictions.eq((String)"archivedFlag", (Object)false));
        c.setProjection(Projections.rowCount());
        if (sandbox == null) {
            c.add(Restrictions.isNull((String)"sandbox"));
            return (Long)c.uniqueResult();
        }
        SimpleExpression originalSandboxExpression = Restrictions.eq((String)"originalSandBox", (Object)sandbox);
        SimpleExpression currentSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox);
        if (sandbox.getSite() == null || sandbox.getSite().getProductionSandbox() == null) {
            productionSandboxExpression = Restrictions.isNull((String)"sandbox");
        } else {
            if (sandbox.getId().equals(sandbox.getSite().getProductionSandbox().getId())) {
                return (Long)c.uniqueResult();
            }
            productionSandboxExpression = Restrictions.eq((String)"sandbox", (Object)sandbox.getSite().getProductionSandbox());
        }
        c.add((Criterion)Restrictions.or((Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)productionSandboxExpression), (Criterion)originalSandboxExpression));
        Long resultCount = (Long)c.list().get(0);
        Long updatedCount = 0L;
        Long deletedCount = 0L;
        c.add((Criterion)Restrictions.and((Criterion)Restrictions.isNotNull((String)"originalItemId"), (Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression)));
        updatedCount = (Long)c.list().get(0);
        c.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"deletedFlag", (Object)true), (Criterion)Restrictions.or((Criterion)currentSandboxExpression, (Criterion)originalSandboxExpression)));
        deletedCount = (Long)c.list().get(0);
        return resultCount - updatedCount - deletedCount;
    }

    @Override
    public StructuredContent addStructuredContent(StructuredContent content, SandBox destinationSandbox) {
        content.setSandbox(destinationSandbox);
        content.setArchivedFlag(false);
        content.setDeletedFlag(false);
        StructuredContent sc = this.structuredContentDao.addOrUpdateContentItem(content);
        if (!this.isProductionSandBox(destinationSandbox)) {
            this.sandBoxItemDao.addSandBoxItem(destinationSandbox, SandBoxOperationType.ADD, SandBoxItemType.STRUCTURED_CONTENT, sc.getContentName(), sc.getId(), null);
        }
        return sc;
    }

    @Override
    public StructuredContent updateStructuredContent(StructuredContent content, SandBox destSandbox) {
        if (content.getLockedFlag().booleanValue()) {
            throw new IllegalArgumentException("Unable to update a locked record");
        }
        if (this.checkForSandboxMatch(content.getSandbox(), destSandbox)) {
            if (content.getDeletedFlag().booleanValue()) {
                SandBoxItem item = this.sandBoxItemDao.retrieveBySandboxAndTemporaryItemId(content.getSandbox(), SandBoxItemType.STRUCTURED_CONTENT, content.getId());
                if (content.getOriginalItemId() == null) {
                    content.setArchivedFlag(true);
                    item.setArchivedFlag(Boolean.valueOf(true));
                } else {
                    item.setSandBoxOperationType(SandBoxOperationType.DELETE);
                    this.sandBoxItemDao.updateSandBoxItem(item);
                }
            }
            return this.structuredContentDao.addOrUpdateContentItem(content);
        }
        if (this.checkForProductionSandbox(content.getSandbox())) {
            StructuredContent clonedContent = content.cloneEntity();
            clonedContent.setOriginalItemId(content.getId());
            clonedContent.setSandbox(destSandbox);
            this.structuredContentDao.detach(content);
            StructuredContent returnContent = this.structuredContentDao.addOrUpdateContentItem(clonedContent);
            StructuredContent prod = this.findStructuredContentById(content.getId());
            prod.setLockedFlag(true);
            prod = this.structuredContentDao.addOrUpdateContentItem(prod);
            SandBoxOperationType type = SandBoxOperationType.UPDATE;
            if (clonedContent.getDeletedFlag().booleanValue()) {
                type = SandBoxOperationType.DELETE;
            }
            this.sandBoxItemDao.addSandBoxItem(destSandbox, type, SandBoxItemType.STRUCTURED_CONTENT, returnContent.getContentName(), returnContent.getId(), returnContent.getOriginalItemId());
            return returnContent;
        }
        throw new IllegalArgumentException("Update called when promote or reject was expected.");
    }

    private boolean checkForSandboxMatch(SandBox src, SandBox dest) {
        if (src != null && dest != null) {
            return src.getId().equals(dest.getId());
        }
        return src == null && dest == null;
    }

    private boolean checkForProductionSandbox(SandBox dest) {
        boolean productionSandbox = false;
        if (dest == null) {
            productionSandbox = true;
        } else if (dest.getSite() != null && dest.getSite().getProductionSandbox() != null && dest.getSite().getProductionSandbox().getId() != null) {
            productionSandbox = dest.getSite().getProductionSandbox().getId().equals(dest.getId());
        }
        return productionSandbox;
    }

    @Override
    public void deleteStructuredContent(StructuredContent content, SandBox destinationSandbox) {
        content.setDeletedFlag(true);
        this.updateStructuredContent(content, destinationSandbox);
    }

    private List<StructuredContent> mergeContent(List<StructuredContent> productionList, List<StructuredContent> sandboxList) {
        if (sandboxList == null || sandboxList.size() == 0) {
            return productionList;
        }
        LinkedHashMap<Long, StructuredContent> scMap = new LinkedHashMap<Long, StructuredContent>();
        for (StructuredContent sc : productionList) {
            scMap.put(sc.getId(), sc);
        }
        for (StructuredContent sc : sandboxList) {
            if (sc.getOriginalItemId() != null) {
                scMap.remove(sc.getOriginalItemId());
            }
            if (sc.getDeletedFlag().booleanValue() || sc.getOfflineFlag().booleanValue()) continue;
            scMap.put(sc.getId(), sc);
        }
        ArrayList<StructuredContent> returnList = new ArrayList<StructuredContent>(scMap.values());
        if (returnList.size() > 1) {
            Collections.sort(returnList, new BeanComparator("priority"));
        }
        return returnList;
    }

    private List<StructuredContent> evaluateAndPriortizeContent(List<StructuredContent> structuredContentList, int count, Map<String, Object> ruleDTOs) {
        Iterator<StructuredContent> structuredContentIterator = structuredContentList.iterator();
        ArrayList<StructuredContent> returnList = new ArrayList<StructuredContent>();
        ArrayList<StructuredContent> tmpList = new ArrayList<StructuredContent>();
        Integer lastPriority = Integer.MIN_VALUE;
        while (structuredContentIterator.hasNext()) {
            StructuredContent sc = structuredContentIterator.next();
            if (!lastPriority.equals(sc.getPriority())) {
                if (tmpList.size() > 1) {
                    Collections.shuffle(tmpList);
                }
                returnList.addAll(tmpList);
                tmpList.clear();
                if (returnList.size() == count) {
                    return returnList;
                }
                if (returnList.size() > count) {
                    return returnList.subList(0, count);
                }
                if (this.processContentRules(sc, ruleDTOs)) {
                    tmpList.add(sc);
                }
            } else if (this.processContentRules(sc, ruleDTOs)) {
                tmpList.add(sc);
            }
            lastPriority = sc.getPriority();
        }
        if (tmpList.size() > 1) {
            Collections.shuffle(tmpList);
        }
        returnList.addAll(tmpList);
        if (returnList.size() > count) {
            return returnList.subList(0, count);
        }
        return returnList;
    }

    private boolean processContentRules(StructuredContent sc, Map<String, Object> ruleDTOs) {
        if (this.contentRuleProcessors != null) {
            for (StructuredContentRuleProcessor processor : this.contentRuleProcessors) {
                boolean matchFound = processor.checkForMatch(sc, ruleDTOs);
                if (matchFound) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<StructuredContent> lookupStructuredContentItemsByType(SandBox sandBox, StructuredContentType contentType, Locale locale, Integer count, Map<String, Object> ruleDTOs) {
        List<StructuredContent> productionContentList = null;
        List<StructuredContent> sandBoxContentList = null;
        productionContentList = this.structuredContentDao.findActiveStructuredContentByType(this.getProductionSandBox(sandBox), contentType, locale);
        if (!this.isProductionSandBox(sandBox)) {
            sandBoxContentList = this.structuredContentDao.findActiveStructuredContentByType(sandBox, contentType, locale);
        }
        List<StructuredContent> contentList = this.mergeContent(productionContentList, sandBoxContentList);
        return this.evaluateAndPriortizeContent(contentList, count, ruleDTOs);
    }

    @Override
    public List<StructuredContent> lookupStructuredContentItemsByName(SandBox sandBox, StructuredContentType contentType, String contentName, Locale locale, Integer count, Map<String, Object> ruleDTOs) {
        List<StructuredContent> productionContentList = null;
        List<StructuredContent> sandBoxContentList = null;
        productionContentList = this.structuredContentDao.findActiveStructuredContentByNameAndType(this.getProductionSandBox(sandBox), contentType, contentName, locale);
        if (!this.isProductionSandBox(sandBox)) {
            sandBoxContentList = this.structuredContentDao.findActiveStructuredContentByNameAndType(sandBox, contentType, contentName, locale);
        }
        List<StructuredContent> contentList = this.mergeContent(productionContentList, sandBoxContentList);
        return this.evaluateAndPriortizeContent(contentList, count, ruleDTOs);
    }

    private SandBox getProductionSandBox(SandBox currentSandBox) {
        SandBox productionSandBox = null;
        if (currentSandBox == null || SandBoxType.PRODUCTION.equals((Object)currentSandBox.getSandBoxType())) {
            productionSandBox = currentSandBox;
        } else if (currentSandBox.getSite() != null) {
            productionSandBox = currentSandBox.getSite().getProductionSandbox();
        }
        return productionSandBox;
    }

    private boolean isProductionSandBox(SandBox dest) {
        if (dest == null) {
            return true;
        }
        return SandBoxType.PRODUCTION.equals((Object)dest.getSandBoxType());
    }

    public void itemPromoted(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STRUCTURED_CONTENT.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StructuredContent sc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getTemporaryItemId());
        if (sc == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Structured Content Item not found " + sandBoxItem.getTemporaryItemId()));
            }
        } else {
            boolean productionSandBox = this.isProductionSandBox(destinationSandBox);
            if (productionSandBox) {
                sc.setLockedFlag(false);
            } else {
                sc.setLockedFlag(true);
            }
            if (productionSandBox && sc.getOriginalItemId() != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Structured content promoted to production.  " + sc.getId() + ".  Archiving original item " + sc.getOriginalItemId()));
                }
                StructuredContent originalSC = this.structuredContentDao.findStructuredContentById(sandBoxItem.getOriginalItemId());
                originalSC.setArchivedFlag(Boolean.TRUE);
                this.structuredContentDao.addOrUpdateContentItem(originalSC);
                if (sc.getDeletedFlag().booleanValue()) {
                    sc.setArchivedFlag(true);
                }
                sc.setOriginalItemId(null);
            }
        }
        if (sc.getOriginalSandBox() == null) {
            sc.setOriginalSandBox(sc.getSandbox());
        }
        sc.setSandbox(destinationSandBox);
        this.structuredContentDao.addOrUpdateContentItem(sc);
    }

    public void itemRejected(SandBoxItem sandBoxItem, SandBox destinationSandBox) {
        if (!SandBoxItemType.STRUCTURED_CONTENT.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StructuredContent sc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getTemporaryItemId());
        if (sc != null) {
            sc.setSandbox(destinationSandBox);
            sc.setOriginalSandBox(null);
            sc.setLockedFlag(false);
            this.structuredContentDao.addOrUpdateContentItem(sc);
        }
    }

    public void itemReverted(SandBoxItem sandBoxItem) {
        if (!SandBoxItemType.STRUCTURED_CONTENT.equals((Object)sandBoxItem.getSandBoxItemType())) {
            return;
        }
        StructuredContent sc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getTemporaryItemId());
        if (sc != null && sandBoxItem.getOriginalItemId() != null) {
            sc.setArchivedFlag(Boolean.TRUE);
            sc.setLockedFlag(Boolean.FALSE);
            this.structuredContentDao.addOrUpdateContentItem(sc);
            StructuredContent originalSc = this.structuredContentDao.findStructuredContentById(sandBoxItem.getOriginalItemId());
            originalSc.setLockedFlag(false);
            this.structuredContentDao.addOrUpdateContentItem(originalSc);
        }
    }

    public List<StructuredContentRuleProcessor> getContentRuleProcessors() {
        return this.contentRuleProcessors;
    }

    public void setContentRuleProcessors(List<StructuredContentRuleProcessor> contentRuleProcessors) {
        this.contentRuleProcessors = contentRuleProcessors;
    }
}

