/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.domain;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import org.broadleafcommerce.cms.file.domain.StaticAsset;
import org.broadleafcommerce.cms.file.domain.StaticAssetDescription;
import org.broadleafcommerce.cms.file.domain.StaticAssetDescriptionImpl;
import org.broadleafcommerce.openadmin.audit.AdminAuditable;
import org.broadleafcommerce.openadmin.audit.AdminAuditableListener;
import org.broadleafcommerce.openadmin.client.dto.VisibilityEnum;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.domain.SandBoxImpl;
import org.broadleafcommerce.openadmin.server.domain.Site;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.broadleafcommerce.presentation.AdminPresentationClass;
import org.broadleafcommerce.presentation.AdminPresentationOverride;
import org.broadleafcommerce.presentation.AdminPresentationOverrides;
import org.broadleafcommerce.presentation.PopulateToOneFieldsEnum;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.MapKey;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@EntityListeners(value={AdminAuditableListener.class})
@Table(name="BLC_STATIC_ASSET")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
@AdminPresentationOverrides(value={@AdminPresentationOverride(name="auditable.createdBy.name", value=@AdminPresentation(readOnly=true, visibility=VisibilityEnum.HIDDEN_ALL)), @AdminPresentationOverride(name="auditable.updatedBy.name", value=@AdminPresentation(readOnly=true, visibility=VisibilityEnum.HIDDEN_ALL)), @AdminPresentationOverride(name="auditable.dateCreated", value=@AdminPresentation(readOnly=true, visibility=VisibilityEnum.HIDDEN_ALL)), @AdminPresentationOverride(name="auditable.dateUpdated", value=@AdminPresentation(readOnly=true, visibility=VisibilityEnum.HIDDEN_ALL)), @AdminPresentationOverride(name="auditable.createdBy.login", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.createdBy.password", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.createdBy.email", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.createdBy.currentSandBox", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.updatedBy.login", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.updatedBy.password", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.updatedBy.email", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="auditable.updatedBy.currentSandBox", value=@AdminPresentation(excluded=true)), @AdminPresentationOverride(name="sandbox", value=@AdminPresentation(excluded=true))})
@AdminPresentationClass(populateToOneFields=PopulateToOneFieldsEnum.TRUE)
public class StaticAssetImpl
implements StaticAsset {
    @Id
    @GeneratedValue(generator="StaticAssetId", strategy=GenerationType.TABLE)
    @TableGenerator(name="StaticAssetId", table="SEQUENCE_GENERATOR", pkColumnName="ID_NAME", valueColumnName="ID_VAL", pkColumnValue="StaticAssetFolderImpl", allocationSize=10)
    @Column(name="STATIC_ASSET_ID")
    protected Long id;
    @Embedded
    protected AdminAuditable auditable = new AdminAuditable();
    @Column(name="NAME", nullable=false)
    @AdminPresentation(friendlyName="Item Name", order=1, group="Details")
    protected String name;
    @Transient
    @AdminPresentation(excluded=true)
    protected Site site;
    @Column(name="FULL_URL", nullable=false)
    @AdminPresentation(friendlyName="Full URL", order=2, group="Details")
    @Index(name="ASST_FULL_URL_INDX", columnNames={"FULL_URL"})
    protected String fullUrl;
    @Column(name="FILE_SIZE")
    @AdminPresentation(friendlyName="File Size (Bytes)", order=3, group="Details", readOnly=true)
    protected Long fileSize;
    @Column(name="MIME_TYPE")
    @AdminPresentation(friendlyName="Mime Type", order=4, group="Details", readOnly=true)
    protected String mimeType;
    @Column(name="FILE_EXTENSION")
    @AdminPresentation(friendlyName="File Extension", order=5, group="Details", readOnly=true)
    protected String fileExtension;
    @ManyToMany(targetEntity=StaticAssetDescriptionImpl.class, cascade={CascadeType.ALL})
    @JoinTable(name="BLC_ASSET_DESC_MAP", joinColumns={@JoinColumn(name="STATIC_ASSET_ID")}, inverseJoinColumns={@JoinColumn(name="STATIC_ASSET_DESC_ID")})
    @MapKey(columns={@Column(name="MAP_KEY", nullable=false)})
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE, region="blCMSElements")
    @BatchSize(size=20)
    protected Map<String, StaticAssetDescription> contentMessageValues = new HashMap<String, StaticAssetDescription>();
    @ManyToOne(targetEntity=SandBoxImpl.class)
    @JoinColumn(name="SANDBOX_ID")
    @AdminPresentation(excluded=true)
    protected SandBox sandbox;
    @ManyToOne(targetEntity=SandBoxImpl.class)
    @JoinColumn(name="ORIG_SANDBOX_ID")
    @AdminPresentation(excluded=true)
    protected SandBox originalSandBox;
    @Column(name="ARCHIVED_FLAG")
    @AdminPresentation(friendlyName="Archived Flag", visibility=VisibilityEnum.HIDDEN_ALL)
    @Index(name="ASST_ARCHVD_FLG_INDX", columnNames={"ARCHIVED_FLAG"})
    protected Boolean archivedFlag = false;
    @Column(name="DELETED_FLAG")
    @AdminPresentation(friendlyName="Deleted Flag", visibility=VisibilityEnum.HIDDEN_ALL)
    @Index(name="ASST_DLTD_FLG_INDX", columnNames={"DELETED_FLAG"})
    protected Boolean deletedFlag = false;
    @Column(name="LOCKED_FLAG")
    @AdminPresentation(friendlyName="Is Locked", visibility=VisibilityEnum.HIDDEN_ALL)
    @Index(name="ASST_LCKD_FLG_INDX", columnNames={"LOCKED_FLAG"})
    protected Boolean lockedFlag = false;
    @Column(name="ORIG_ASSET_ID")
    @AdminPresentation(friendlyName="Original Asset ID", visibility=VisibilityEnum.HIDDEN_ALL)
    @Index(name="ORIG_ASSET_ID_INDX", columnNames={"ORIG_ASSET_ID"})
    protected Long originalAssetId;

    @Override
    public String getFullUrl() {
        return this.fullUrl;
    }

    @Override
    public void setFullUrl(String fullUrl) {
        this.fullUrl = fullUrl;
    }

    @Override
    public Long getFileSize() {
        return this.fileSize;
    }

    @Override
    public void setFileSize(Long fileSize) {
        this.fileSize = fileSize;
    }

    @Override
    public Map<String, StaticAssetDescription> getContentMessageValues() {
        return this.contentMessageValues;
    }

    @Override
    public void setContentMessageValues(Map<String, StaticAssetDescription> contentMessageValues) {
        this.contentMessageValues = contentMessageValues;
    }

    @Override
    public Boolean getArchivedFlag() {
        if (this.archivedFlag == null) {
            return Boolean.FALSE;
        }
        return this.archivedFlag;
    }

    @Override
    public void setArchivedFlag(Boolean archivedFlag) {
        this.archivedFlag = archivedFlag;
    }

    @Override
    public Long getOriginalAssetId() {
        return this.originalAssetId;
    }

    @Override
    public void setOriginalAssetId(Long originalAssetId) {
        this.originalAssetId = originalAssetId;
    }

    @Override
    public SandBox getSandbox() {
        return this.sandbox;
    }

    @Override
    public void setSandbox(SandBox sandbox) {
        this.sandbox = sandbox;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @Override
    public String getFileExtension() {
        return this.fileExtension;
    }

    @Override
    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Override
    public SandBox getOriginalSandBox() {
        return this.originalSandBox;
    }

    @Override
    public void setOriginalSandBox(SandBox originalSandBox) {
        this.originalSandBox = originalSandBox;
    }

    @Override
    public AdminAuditable getAuditable() {
        return this.auditable;
    }

    @Override
    public void setAuditable(AdminAuditable auditable) {
        this.auditable = auditable;
    }

    @Override
    public Boolean getDeletedFlag() {
        return this.deletedFlag;
    }

    @Override
    public void setDeletedFlag(Boolean deletedFlag) {
        this.deletedFlag = deletedFlag;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public Boolean getLockedFlag() {
        return this.lockedFlag;
    }

    @Override
    public void setLockedFlag(Boolean lockedFlag) {
        this.lockedFlag = lockedFlag;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public Site getSite() {
        return this.site;
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
    }

    @Override
    public StaticAsset cloneEntity() {
        StaticAssetImpl asset = new StaticAssetImpl();
        asset.name = this.name;
        asset.site = this.site;
        asset.archivedFlag = this.archivedFlag;
        asset.deletedFlag = this.deletedFlag;
        asset.fullUrl = this.fullUrl;
        asset.fileSize = this.fileSize;
        asset.mimeType = this.mimeType;
        asset.sandbox = this.sandbox;
        asset.originalSandBox = this.originalSandBox;
        asset.originalAssetId = this.originalAssetId;
        asset.fileExtension = this.fileExtension;
        for (String key : this.contentMessageValues.keySet()) {
            StaticAssetDescription oldAssetDescription = this.contentMessageValues.get(key);
            StaticAssetDescription newAssetDescription = oldAssetDescription.cloneEntity();
            asset.getContentMessageValues().put(key, newAssetDescription);
        }
        return asset;
    }
}

