/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.file.domain;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import org.broadleafcommerce.cms.file.domain.ImageStaticAsset;
import org.broadleafcommerce.cms.file.domain.StaticAssetDescription;
import org.broadleafcommerce.cms.file.domain.StaticAssetImpl;
import org.broadleafcommerce.openadmin.audit.AdminAuditableListener;
import org.broadleafcommerce.presentation.AdminPresentation;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Inheritance(strategy=InheritanceType.JOINED)
@EntityListeners(value={AdminAuditableListener.class})
@Table(name="BLC_IMG_STATIC_ASSET")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE, region="blCMSElements")
public class ImageStaticAssetImpl
extends StaticAssetImpl
implements ImageStaticAsset {
    @Column(name="WIDTH")
    @AdminPresentation(friendlyName="Width", order=1, group="Image Details", readOnly=true)
    protected Integer width;
    @Column(name="HEIGHT")
    @AdminPresentation(friendlyName="Height", order=2, group="Image Details", readOnly=true)
    protected Integer height;

    @Override
    public Integer getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(Integer width) {
        this.width = width;
    }

    @Override
    public Integer getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(Integer height) {
        this.height = height;
    }

    @Override
    public ImageStaticAsset cloneEntity() {
        ImageStaticAssetImpl asset = new ImageStaticAssetImpl();
        asset.name = this.name;
        asset.site = this.site;
        asset.archivedFlag = this.archivedFlag;
        asset.deletedFlag = this.deletedFlag;
        asset.fullUrl = this.fullUrl;
        asset.fileSize = this.fileSize;
        asset.mimeType = this.mimeType;
        asset.sandbox = this.sandbox;
        asset.originalAssetId = this.originalAssetId;
        asset.width = this.width;
        asset.height = this.height;
        for (String key : this.contentMessageValues.keySet()) {
            StaticAssetDescription oldAssetDescription = (StaticAssetDescription)this.contentMessageValues.get(key);
            StaticAssetDescription newAssetDescription = oldAssetDescription.cloneEntity();
            asset.getContentMessageValues().put(key, newAssetDescription);
        }
        return asset;
    }
}

