/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.broadleafcommerce.cms.structure.domain.StructuredContent;
import org.broadleafcommerce.cms.structure.domain.StructuredContentType;
import org.broadleafcommerce.cms.structure.service.StructuredContentService;
import org.broadleafcommerce.cms.web.BroadleafProcessURLFilter;
import org.broadleafcommerce.cms.web.utility.FieldMapWrapper;
import org.broadleafcommerce.common.RequestDTO;
import org.broadleafcommerce.common.TimeDTO;
import org.broadleafcommerce.common.locale.domain.Locale;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.time.SystemTime;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DisplayContentTag
extends BodyTagSupport {
    private static final long serialVersionUID = 1L;
    public static final String BLC_RULE_MAP_PARAM = "blRuleMap";
    public static final String REQUEST_DTO = "blRequestDTO";
    private String contentType;
    private String contentName;
    private Object product;
    private Integer count;
    private String contentListVar = "contentList";
    private String contentItemVar = "contentItem";
    private String numResultsVar = "numResults";
    private Locale locale;
    private StructuredContentService structuredContentService;

    private Map<String, Object> buildMvelParameters(HttpServletRequest request) {
        TimeDTO timeDto = SystemTime.asTimeDTO();
        RequestDTO requestDto = (RequestDTO)request.getAttribute(REQUEST_DTO);
        HashMap<String, Object> mvelParameters = new HashMap<String, Object>();
        mvelParameters.put("time", timeDto);
        mvelParameters.put("request", requestDto);
        Map blcRuleMap = (Map)request.getAttribute(BLC_RULE_MAP_PARAM);
        if (blcRuleMap != null) {
            for (String mapKey : blcRuleMap.keySet()) {
                mvelParameters.put(mapKey, blcRuleMap.get(mapKey));
            }
        }
        if (this.product != null) {
            mvelParameters.put("product", this.product);
        }
        return mvelParameters;
    }

    protected StructuredContentService getStructuredContentService(PageContext context) {
        if (this.structuredContentService == null) {
            WebApplicationContext applicationContext = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.pageContext.getServletContext());
            this.structuredContentService = (StructuredContentService)applicationContext.getBean("blStructuredContentService");
        }
        return this.structuredContentService;
    }

    private List<Map> wrapFieldMaps(List<StructuredContent> contentItems) {
        if (contentItems != null) {
            ArrayList<Map> contentFieldList = new ArrayList<Map>();
            for (StructuredContent item : contentItems) {
                contentFieldList.add(new FieldMapWrapper(item.getStructuredContentFields()));
            }
            return contentFieldList;
        }
        return null;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.pageContext.getRequest();
        Map<String, Object> mvelParameters = this.buildMvelParameters(request);
        SandBox currentSandbox = (SandBox)request.getAttribute(BroadleafProcessURLFilter.SANDBOX_VAR);
        StructuredContentType structuredContentType = this.getStructuredContentService(this.pageContext).findStructuredContentTypeByName(this.contentType);
        if (this.locale == null) {
            this.locale = (Locale)request.getAttribute(BroadleafProcessURLFilter.LOCALE_VAR);
        }
        int cnt = this.count == null ? Integer.MAX_VALUE : this.count;
        List<StructuredContent> contentItems = this.contentName == null || "".equals(this.contentName) ? this.structuredContentService.lookupStructuredContentItemsByType(currentSandbox, structuredContentType, this.locale, cnt, mvelParameters) : this.structuredContentService.lookupStructuredContentItemsByName(currentSandbox, structuredContentType, this.contentName, this.locale, cnt, mvelParameters);
        this.pageContext.setAttribute(this.getNumResultsVar(), (Object)contentItems.size());
        if (contentItems.size() > 0) {
            List<Map> returnFields = this.wrapFieldMaps(contentItems);
            this.pageContext.setAttribute(this.contentItemVar, (Object)returnFields.get(0));
            this.pageContext.setAttribute(this.contentListVar, returnFields);
            this.pageContext.setAttribute("structuredContentList", contentItems);
            this.pageContext.setAttribute(this.numResultsVar, (Object)contentItems.size());
        } else {
            this.pageContext.setAttribute(this.contentItemVar, contentItems);
            this.pageContext.setAttribute(this.contentListVar, null);
            this.pageContext.setAttribute("structuredContentList", null);
            this.pageContext.setAttribute(this.numResultsVar, (Object)0);
        }
        return 1;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getContentName() {
        return this.contentName;
    }

    public void setContentName(String contentName) {
        this.contentName = contentName;
    }

    public Integer getCount() {
        return this.count;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public String getContentListVar() {
        return this.contentListVar;
    }

    public void setContentListVar(String contentVar) {
        this.contentListVar = contentVar;
    }

    public String getContentItemVar() {
        return this.contentItemVar;
    }

    public void setContentItemVar(String contentItemVar) {
        this.contentItemVar = contentItemVar;
    }

    public String getNumResultsVar() {
        return this.numResultsVar;
    }

    public void setNumResultsVar(String numResultsVar) {
        this.numResultsVar = numResultsVar;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Object getProduct() {
        return this.product;
    }

    public void setProduct(Object product) {
        this.product = product;
    }
}

