/*
 * Decompiled with CFR 0.152.
 */
package org.broadleafcommerce.cms.web.file;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.broadleafcommerce.cms.file.service.StaticAssetStorageService;
import org.broadleafcommerce.openadmin.server.domain.SandBox;
import org.broadleafcommerce.openadmin.server.service.persistence.SandBoxService;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;

@Controller(value="blStaticAssetViewController")
public class StaticAssetViewController {
    private static final Log LOG = LogFactory.getLog(StaticAssetViewController.class);
    private static final String SANDBOX_ADMIN_ID_VAR = "blAdminCurrentSandboxId";
    private static final String SANDBOX_ID_VAR = "blSandboxId";
    @Resource(name="blStaticAssetStorageService")
    protected StaticAssetStorageService staticAssetStorageService;
    @Resource(name="blSandBoxService")
    protected SandBoxService sandBoxService;

    @RequestMapping(value={"/**/{fileName}"}, method={RequestMethod.GET})
    public ModelAndView viewItem(@PathVariable String fileName, HttpServletRequest request) {
        try {
            String fullUrl = "/" + fileName;
            Long sandBoxId = (Long)request.getSession().getAttribute(SANDBOX_ID_VAR);
            if (sandBoxId == null) {
                sandBoxId = (Long)request.getSession().getAttribute(SANDBOX_ADMIN_ID_VAR);
            }
            SandBox sandBox = null;
            if (sandBoxId != null) {
                sandBox = this.sandBoxService.retrieveSandboxById(sandBoxId);
            }
            Map<String, String> model = this.staticAssetStorageService.getCacheFileModel(fullUrl, sandBox, this.convertParameterMap(request.getParameterMap()));
            return new ModelAndView("blStaticAssetView", model);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to retrieve static asset", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected Map<String, String> convertParameterMap(Map<String, String[]> parameterMap) {
        HashMap<String, String> convertedMap = new HashMap<String, String>(parameterMap.size());
        for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
            convertedMap.put(entry.getKey(), StringUtils.join((Object[])entry.getValue(), (char)','));
        }
        return convertedMap;
    }
}

